/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.space;

import com.gigaspaces.executor.SpaceTask;
import com.gigaspaces.internal.client.spaceproxy.IDirectSpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.executors.AddReplicationGatewayTargetTask;
import com.gigaspaces.internal.client.spaceproxy.executors.RemoveReplicationGatewayTargetTask;
import com.gigaspaces.internal.cluster.SpaceClusterInfo;
import com.gigaspaces.internal.cluster.node.impl.gateway.GatewayConfig;
import com.gigaspaces.internal.cluster.node.impl.gateway.GatewayPolicy;
import com.gigaspaces.internal.cluster.node.impl.gateway.GatewaysPolicy;
import com.gigaspaces.internal.space.requests.AddReplicationGatewayTargetRequestInfo;
import com.gigaspaces.internal.space.requests.RemoveReplicationGatewayTargetRequestInfo;
import java.rmi.RemoteException;
import java.util.concurrent.ExecutionException;
import net.jini.core.transaction.TransactionException;
import org.openspaces.admin.AdminException;
import org.openspaces.admin.internal.space.DefaultSpace;
import org.openspaces.admin.space.SpaceReplicationManager;
import org.openspaces.core.GigaSpace;
import org.openspaces.core.gateway.GatewayTarget;

public class DefaultSpaceReplicationManager
implements SpaceReplicationManager {
    private final DefaultSpace _defaultSpace;

    public DefaultSpaceReplicationManager(DefaultSpace defaultSpace) {
        this._defaultSpace = defaultSpace;
    }

    @Override
    public void addGatewayTarget(GatewayTarget gatewayTarget) {
        ISpaceProxy spaceProxy = DefaultSpaceReplicationManager.getDirectSpaceProxy(this._defaultSpace.getGigaSpace());
        GatewayConfig gatewayConfig = GatewayConfig.fromClusterInfo((SpaceClusterInfo)spaceProxy.getDirectProxy().getSpaceClusterInfo());
        GatewaysPolicy gatewaysPolicy = gatewayConfig.getGatewaysPolicy();
        if (gatewaysPolicy == null) {
            throw new UnsupportedOperationException("Cannot add replication gateway target to a space with no gateways");
        }
        GatewayPolicy defaultGatewayPolicy = gatewaysPolicy.getDefaultGatewayPolicy();
        GatewayPolicy gatewayPolicy = defaultGatewayPolicy != null ? gatewayTarget.asGatewayPolicy(defaultGatewayPolicy) : gatewayTarget.asGatewayPolicy();
        try {
            AddReplicationGatewayTargetRequestInfo requestInfo = new AddReplicationGatewayTargetRequestInfo();
            requestInfo.gatewayPolicy = gatewayPolicy;
            AddReplicationGatewayTargetTask task = new AddReplicationGatewayTargetTask(requestInfo);
            spaceProxy.execute((SpaceTask)task, null, null, null).get();
        }
        catch (ExecutionException e) {
            this.removeGatewayTargetDueToFailedUponAddition(spaceProxy, gatewayPolicy.getGatewayName());
            throw new AdminException("failed to add a replication gateway target", e.getCause());
        }
        catch (Exception e) {
            this.removeGatewayTargetDueToFailedUponAddition(spaceProxy, gatewayPolicy.getGatewayName());
            throw new AdminException("failed to add a replication gateway target", e);
        }
    }

    private void removeGatewayTargetDueToFailedUponAddition(ISpaceProxy spaceProxy, String gatewayTargetName) {
        try {
            this.removeGatewayTarget(spaceProxy, gatewayTargetName);
        }
        catch (RemoteException remoteException) {
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
        }
        catch (TransactionException transactionException) {
            // empty catch block
        }
    }

    private void removeGatewayTarget(ISpaceProxy spaceProxy, String gatewayTargetName) throws RemoteException, TransactionException, ExecutionException, InterruptedException {
        RemoveReplicationGatewayTargetRequestInfo requestInfo = new RemoveReplicationGatewayTargetRequestInfo();
        requestInfo.gatewayTargetName = gatewayTargetName;
        RemoveReplicationGatewayTargetTask task = new RemoveReplicationGatewayTargetTask(requestInfo);
        spaceProxy.execute((SpaceTask)task, null, null, null).get();
    }

    @Override
    public void removeGatewayTarget(String gatewayTargetName) {
        ISpaceProxy spaceProxy = DefaultSpaceReplicationManager.getDirectSpaceProxy(this._defaultSpace.getGigaSpace());
        try {
            this.removeGatewayTarget(spaceProxy, gatewayTargetName);
        }
        catch (ExecutionException e) {
            throw new AdminException("failed to remove a replication gateway target", e.getCause());
        }
        catch (Exception e) {
            throw new AdminException("failed to remove a replication gateway target", e);
        }
    }

    private static ISpaceProxy getDirectSpaceProxy(GigaSpace gigaSpace) {
        ISpaceProxy spaceProxy = (ISpaceProxy)gigaSpace.getSpace();
        if (!(spaceProxy instanceof IDirectSpaceProxy)) {
            throw new UnsupportedOperationException("Cannot add/remove replication gateway target to a near cache");
        }
        return spaceProxy;
    }
}

