/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.space;

import com.gigaspaces.cluster.activeelection.SpaceMode;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.openspaces.admin.internal.space.DefaultSpace;
import org.openspaces.admin.internal.space.DefaultSpaceConnectionDetails;
import org.openspaces.admin.internal.space.DefaultSpaceTransactionDetails;
import org.openspaces.admin.space.SpaceConnectionDetails;
import org.openspaces.admin.space.SpaceInstance;
import org.openspaces.admin.space.SpaceRuntimeDetails;
import org.openspaces.admin.space.SpaceTransactionDetails;

public class DefaultSpaceRuntimeDetails
implements SpaceRuntimeDetails {
    private final DefaultSpace defaultSpace;
    private final DefaultSpaceTransactionDetails spaceTransactionDetails;
    private final DefaultSpaceConnectionDetails spaceConnectionDetails;

    public DefaultSpaceRuntimeDetails(DefaultSpace defaultSpace) {
        this.defaultSpace = defaultSpace;
        this.spaceTransactionDetails = new DefaultSpaceTransactionDetails(defaultSpace);
        this.spaceConnectionDetails = new DefaultSpaceConnectionDetails(defaultSpace);
    }

    @Override
    public String[] getClassNames() {
        TreeSet<String> classNames = new TreeSet<String>();
        for (SpaceInstance spaceInstance : this.defaultSpace.getSpaceInstances()) {
            if (spaceInstance.getMode() != SpaceMode.PRIMARY) continue;
            for (String className : spaceInstance.getRuntimeDetails().getClassNames()) {
                classNames.add(className);
            }
        }
        return classNames.toArray(new String[classNames.size()]);
    }

    @Override
    public int getCount() {
        int count = 0;
        for (SpaceInstance spaceInstance : this.defaultSpace.getSpaceInstances()) {
            if (spaceInstance.getMode() != SpaceMode.PRIMARY) continue;
            count += spaceInstance.getRuntimeDetails().getCount();
        }
        return count;
    }

    @Override
    public Map<String, Integer> getCountPerClassName() {
        HashMap<String, Integer> mapping = new HashMap<String, Integer>();
        for (SpaceInstance spaceInstance : this.defaultSpace.getSpaceInstances()) {
            if (spaceInstance.getMode() != SpaceMode.PRIMARY) continue;
            Map<String, Integer> countPerClassName = spaceInstance.getRuntimeDetails().getCountPerClassName();
            for (Map.Entry<String, Integer> entry : countPerClassName.entrySet()) {
                Integer value = (Integer)mapping.get(entry.getKey());
                if (value == null) {
                    mapping.put(entry.getKey(), entry.getValue());
                    continue;
                }
                int newValue = value + entry.getValue();
                mapping.put(entry.getKey(), newValue);
            }
        }
        return mapping;
    }

    @Override
    public Map<String, Integer> getNotifyTemplateCountPerClassName() {
        HashMap<String, Integer> mapping = new HashMap<String, Integer>();
        for (SpaceInstance spaceInstance : this.defaultSpace.getSpaceInstances()) {
            if (spaceInstance.getMode() != SpaceMode.PRIMARY) continue;
            Map<String, Integer> notifyTemplateCountPerClassName = spaceInstance.getRuntimeDetails().getNotifyTemplateCountPerClassName();
            for (Map.Entry<String, Integer> entry : notifyTemplateCountPerClassName.entrySet()) {
                Integer value = (Integer)mapping.get(entry.getKey());
                if (value == null) {
                    mapping.put(entry.getKey(), entry.getValue());
                    continue;
                }
                int newValue = value + entry.getValue();
                mapping.put(entry.getKey(), newValue);
            }
        }
        return mapping;
    }

    @Override
    public SpaceTransactionDetails getTransactionDetails() {
        return this.spaceTransactionDetails;
    }

    @Override
    public SpaceConnectionDetails getConnectionDetails() {
        return this.spaceConnectionDetails;
    }
}

