/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.space;

import java.util.ArrayList;
import java.util.List;
import org.openspaces.admin.space.SpaceInstanceStatistics;
import org.openspaces.admin.space.SpaceStatistics;

public class DefaultSpaceStatistics
implements SpaceStatistics {
    private final long timestamp;
    private final SpaceInstanceStatistics[] stats;
    private volatile SpaceStatistics previous;

    public DefaultSpaceStatistics(SpaceInstanceStatistics[] stats, SpaceStatistics previous, int historySize) {
        this.stats = stats;
        this.timestamp = System.currentTimeMillis();
        this.previous = previous;
        SpaceStatistics lastStats = previous;
        if (lastStats != null) {
            for (int i = 0; i < historySize && lastStats.getPrevious() != null; ++i) {
                lastStats = lastStats.getPrevious();
            }
            ((DefaultSpaceStatistics)lastStats).setPrevious(null);
        }
    }

    @Override
    public boolean isNA() {
        return this.stats == null || this.stats.length == 0 || this.stats[0].isNA();
    }

    @Override
    public SpaceStatistics getPrevious() {
        return this.previous;
    }

    public void setPrevious(SpaceStatistics previous) {
        this.previous = previous;
    }

    @Override
    public int getSize() {
        return this.stats.length;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public long getWriteCount() {
        long total = 0L;
        for (SpaceInstanceStatistics stat : this.stats) {
            if (stat.isNA()) continue;
            total += stat.getWriteCount();
        }
        return total;
    }

    @Override
    public double getWritePerSecond() {
        double total = 0.0;
        for (SpaceInstanceStatistics stat : this.stats) {
            if (stat.isNA()) continue;
            total += stat.getWritePerSecond();
        }
        return total;
    }

    @Override
    public long getReadCount() {
        long total = 0L;
        for (SpaceInstanceStatistics stat : this.stats) {
            if (stat.isNA()) continue;
            total += stat.getReadCount();
        }
        return total;
    }

    @Override
    public double getReadPerSecond() {
        double total = 0.0;
        for (SpaceInstanceStatistics stat : this.stats) {
            if (stat.isNA()) continue;
            total += stat.getReadPerSecond();
        }
        return total;
    }

    @Override
    public long getTakeCount() {
        long total = 0L;
        for (SpaceInstanceStatistics stat : this.stats) {
            if (stat.isNA()) continue;
            total += stat.getTakeCount();
        }
        return total;
    }

    @Override
    public double getTakePerSecond() {
        double total = 0.0;
        for (SpaceInstanceStatistics stat : this.stats) {
            if (stat.isNA()) continue;
            total += stat.getTakePerSecond();
        }
        return total;
    }

    @Override
    public long getNotifyRegistrationCount() {
        long total = 0L;
        for (SpaceInstanceStatistics stat : this.stats) {
            if (stat.isNA()) continue;
            total += stat.getNotifyRegistrationCount();
        }
        return total;
    }

    @Override
    public double getNotifyRegistrationPerSecond() {
        double total = 0.0;
        for (SpaceInstanceStatistics stat : this.stats) {
            if (stat.isNA()) continue;
            total += stat.getNotifyRegistrationPerSecond();
        }
        return total;
    }

    @Override
    public long getCleanCount() {
        long total = 0L;
        for (SpaceInstanceStatistics stat : this.stats) {
            if (stat.isNA()) continue;
            total += stat.getCleanCount();
        }
        return total;
    }

    @Override
    public double getCleanPerSecond() {
        double total = 0.0;
        for (SpaceInstanceStatistics stat : this.stats) {
            if (stat.isNA()) continue;
            total += stat.getCleanPerSecond();
        }
        return total;
    }

    @Override
    public long getUpdateCount() {
        long total = 0L;
        for (SpaceInstanceStatistics stat : this.stats) {
            if (stat.isNA()) continue;
            total += stat.getUpdateCount();
        }
        return total;
    }

    @Override
    public double getUpdatePerSecond() {
        double total = 0.0;
        for (SpaceInstanceStatistics stat : this.stats) {
            if (stat.isNA()) continue;
            total += stat.getUpdatePerSecond();
        }
        return total;
    }

    @Override
    public long getNotifyTriggerCount() {
        long total = 0L;
        for (SpaceInstanceStatistics stat : this.stats) {
            if (stat.isNA()) continue;
            total += stat.getNotifyTriggerCount();
        }
        return total;
    }

    @Override
    public double getNotifyTriggerPerSecond() {
        double total = 0.0;
        for (SpaceInstanceStatistics stat : this.stats) {
            if (stat.isNA()) continue;
            total += stat.getNotifyRegistrationPerSecond();
        }
        return total;
    }

    @Override
    public long getNotifyAckCount() {
        long total = 0L;
        for (SpaceInstanceStatistics stat : this.stats) {
            if (stat.isNA()) continue;
            total += stat.getNotifyAckCount();
        }
        return total;
    }

    @Override
    public double getNotifyAckPerSecond() {
        double total = 0.0;
        for (SpaceInstanceStatistics stat : this.stats) {
            if (stat.isNA()) continue;
            total += stat.getNotifyAckPerSecond();
        }
        return total;
    }

    @Override
    public long getExecuteCount() {
        long total = 0L;
        for (SpaceInstanceStatistics stat : this.stats) {
            if (stat.isNA()) continue;
            total += stat.getExecuteCount();
        }
        return total;
    }

    @Override
    public double getExecutePerSecond() {
        double total = 0.0;
        for (SpaceInstanceStatistics stat : this.stats) {
            if (stat.isNA()) continue;
            total += stat.getExecutePerSecond();
        }
        return total;
    }

    @Override
    public long getRemoveCount() {
        long total = 0L;
        for (SpaceInstanceStatistics stat : this.stats) {
            if (stat.isNA()) continue;
            total += stat.getRemoveCount();
        }
        return total;
    }

    @Override
    public double getRemovePerSecond() {
        double total = 0.0;
        for (SpaceInstanceStatistics stat : this.stats) {
            if (stat.isNA()) continue;
            total += stat.getRemovePerSecond();
        }
        return total;
    }

    @Override
    public long getChangeCount() {
        long total = 0L;
        for (SpaceInstanceStatistics stat : this.stats) {
            if (stat.isNA()) continue;
            total += stat.getChangeCount();
        }
        return total;
    }

    @Override
    public double getChangePerSecond() {
        double total = 0.0;
        for (SpaceInstanceStatistics stat : this.stats) {
            if (stat.isNA()) continue;
            total += stat.getChangePerSecond();
        }
        return total;
    }

    @Override
    public long getObjectCount() {
        long total = 0L;
        for (SpaceInstanceStatistics stat : this.stats) {
            if (stat.isNA()) continue;
            total += stat.getObjectCount();
        }
        return total;
    }

    @Override
    public long getNotifyTemplateCount() {
        long total = 0L;
        for (SpaceInstanceStatistics stat : this.stats) {
            if (stat.isNA()) continue;
            total += stat.getNotifyTemplateCount();
        }
        return total;
    }

    @Override
    public long getActiveConnectionCount() {
        long total = 0L;
        for (SpaceInstanceStatistics stat : this.stats) {
            if (stat.isNA()) continue;
            total += stat.getActiveConnectionCount();
        }
        return total;
    }

    @Override
    public long getActiveTransactionCount() {
        long total = 0L;
        for (SpaceInstanceStatistics stat : this.stats) {
            if (stat.isNA()) continue;
            total += stat.getActiveTransactionCount();
        }
        return total;
    }

    @Override
    public List<SpaceStatistics> getTimelineFromTimestamp(long fromTimestamp) {
        ArrayList<SpaceStatistics> timeline = new ArrayList<SpaceStatistics>();
        for (SpaceStatistics current = this; current != null && !current.isNA() && current.getTimestamp() > fromTimestamp; current = current.getPrevious()) {
            timeline.add(current);
        }
        return timeline;
    }
}

