/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.space;

import com.j_spaces.kernel.SizeConcurrentHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.openspaces.admin.Admin;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.space.InternalSpace;
import org.openspaces.admin.internal.space.InternalSpaces;
import org.openspaces.admin.internal.space.events.DefaultReplicationStatusChangedEventManager;
import org.openspaces.admin.internal.space.events.DefaultSpaceAddedEventManager;
import org.openspaces.admin.internal.space.events.DefaultSpaceInstanceAddedEventManager;
import org.openspaces.admin.internal.space.events.DefaultSpaceInstanceRemovedEventManager;
import org.openspaces.admin.internal.space.events.DefaultSpaceInstanceStatisticsChangedEventManager;
import org.openspaces.admin.internal.space.events.DefaultSpaceModeChangedEventManager;
import org.openspaces.admin.internal.space.events.DefaultSpaceRemovedEventManager;
import org.openspaces.admin.internal.space.events.DefaultSpaceStatisticsChangedEventManager;
import org.openspaces.admin.internal.space.events.DefaultSpaceSuspendTypeChangedEventManager;
import org.openspaces.admin.internal.space.events.InternalReplicationStatusChangedEventManager;
import org.openspaces.admin.internal.space.events.InternalSpaceAddedEventManager;
import org.openspaces.admin.internal.space.events.InternalSpaceInstanceAddedEventManager;
import org.openspaces.admin.internal.space.events.InternalSpaceInstanceRemovedEventManager;
import org.openspaces.admin.internal.space.events.InternalSpaceInstanceStatisticsChangedEventManager;
import org.openspaces.admin.internal.space.events.InternalSpaceModeChangedEventManager;
import org.openspaces.admin.internal.space.events.InternalSpaceRemovedEventManager;
import org.openspaces.admin.internal.space.events.InternalSpaceStatisticsChangedEventManager;
import org.openspaces.admin.internal.space.events.InternalSpaceSuspendTypeChangedEventManager;
import org.openspaces.admin.space.Space;
import org.openspaces.admin.space.SpaceInstance;
import org.openspaces.admin.space.events.ReplicationStatusChangedEventManager;
import org.openspaces.admin.space.events.SpaceAddedEventListener;
import org.openspaces.admin.space.events.SpaceAddedEventManager;
import org.openspaces.admin.space.events.SpaceInstanceAddedEventManager;
import org.openspaces.admin.space.events.SpaceInstanceLifecycleEventListener;
import org.openspaces.admin.space.events.SpaceInstanceRemovedEventManager;
import org.openspaces.admin.space.events.SpaceInstanceStatisticsChangedEventManager;
import org.openspaces.admin.space.events.SpaceLifecycleEventListener;
import org.openspaces.admin.space.events.SpaceModeChangedEventManager;
import org.openspaces.admin.space.events.SpaceRemovedEventManager;
import org.openspaces.admin.space.events.SpaceStatisticsChangedEventManager;
import org.openspaces.admin.space.events.SpaceSuspendTypeChangedEventManager;

public class DefaultSpaces
implements InternalSpaces {
    private final InternalAdmin admin;
    private final Map<String, Space> spacesByUID = new SizeConcurrentHashMap();
    private final Map<String, Space> spacesByName = new ConcurrentHashMap<String, Space>();
    private final Map<String, SpaceInstance> spacesInstances = new ConcurrentHashMap<String, SpaceInstance>();
    private final InternalSpaceAddedEventManager spaceAddedEventManager;
    private final InternalSpaceRemovedEventManager spaceRemovedEventManager;
    private final InternalSpaceInstanceAddedEventManager spaceInstanceAddedEventManager;
    private final InternalSpaceInstanceRemovedEventManager spaceInstanceRemovedEventManager;
    private final InternalSpaceModeChangedEventManager spaceModeChangedEventManager;
    private final InternalSpaceSuspendTypeChangedEventManager spaceSuspendTypeChangedEventManager;
    private final InternalReplicationStatusChangedEventManager replicationStatusChangedEventManager;
    private final InternalSpaceStatisticsChangedEventManager spaceStatisticsChangedEventManager;
    private final InternalSpaceInstanceStatisticsChangedEventManager spaceInstanceStatisticsChangedEventManager;
    private volatile long statisticsInterval = 5000L;
    private volatile int statisticsHistorySize = 120;
    private volatile boolean scheduledStatisticsMonitor = false;

    public DefaultSpaces(InternalAdmin admin) {
        this.admin = admin;
        this.spaceAddedEventManager = new DefaultSpaceAddedEventManager(this);
        this.spaceRemovedEventManager = new DefaultSpaceRemovedEventManager(this);
        this.spaceInstanceAddedEventManager = new DefaultSpaceInstanceAddedEventManager(admin, this);
        this.spaceInstanceRemovedEventManager = new DefaultSpaceInstanceRemovedEventManager(admin);
        this.spaceModeChangedEventManager = new DefaultSpaceModeChangedEventManager(this, admin);
        this.spaceSuspendTypeChangedEventManager = new DefaultSpaceSuspendTypeChangedEventManager(this, admin);
        this.replicationStatusChangedEventManager = new DefaultReplicationStatusChangedEventManager(admin);
        this.spaceStatisticsChangedEventManager = new DefaultSpaceStatisticsChangedEventManager(admin);
        this.spaceInstanceStatisticsChangedEventManager = new DefaultSpaceInstanceStatisticsChangedEventManager(admin);
    }

    @Override
    public Admin getAdmin() {
        return this.admin;
    }

    @Override
    public void setStatisticsInterval(long interval, TimeUnit timeUnit) {
        this.statisticsInterval = timeUnit.toMillis(interval);
        for (Space space : this.spacesByUID.values()) {
            space.setStatisticsInterval(this.statisticsInterval, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void setStatisticsHistorySize(int historySize) {
        this.statisticsHistorySize = historySize;
        for (Space space : this.spacesByUID.values()) {
            space.setStatisticsHistorySize(historySize);
        }
    }

    @Override
    public void startStatisticsMonitor() {
        this.scheduledStatisticsMonitor = true;
        for (Space space : this.spacesByUID.values()) {
            space.startStatisticsMonitor();
        }
    }

    @Override
    public void stopStatisticsMonitor() {
        this.scheduledStatisticsMonitor = false;
        for (Space space : this.spacesByUID.values()) {
            space.stopStatisticsMonitor();
        }
    }

    @Override
    public boolean isMonitoring() {
        return this.scheduledStatisticsMonitor;
    }

    @Override
    public Space[] getSpaces() {
        return this.spacesByUID.values().toArray(new Space[0]);
    }

    @Override
    public Space getSpaceByUID(String uid) {
        return this.spacesByUID.get(uid);
    }

    @Override
    public Space getSpaceByName(String name) {
        return this.spacesByName.get(name);
    }

    @Override
    public Map<String, Space> getNames() {
        return Collections.unmodifiableMap(this.spacesByName);
    }

    @Override
    public Iterator<Space> iterator() {
        return Collections.unmodifiableCollection(this.spacesByUID.values()).iterator();
    }

    @Override
    public SpaceAddedEventManager getSpaceAdded() {
        return this.spaceAddedEventManager;
    }

    @Override
    public SpaceRemovedEventManager getSpaceRemoved() {
        return this.spaceRemovedEventManager;
    }

    @Override
    public SpaceStatisticsChangedEventManager getSpaceStatisticsChanged() {
        return this.spaceStatisticsChangedEventManager;
    }

    @Override
    public SpaceInstanceStatisticsChangedEventManager getSpaceInstanceStatisticsChanged() {
        return this.spaceInstanceStatisticsChangedEventManager;
    }

    @Override
    public Space waitFor(String spaceName) {
        return this.waitFor(spaceName, this.admin.getDefaultTimeout(), this.admin.getDefaultTimeoutTimeUnit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Space waitFor(final String spaceName, long timeout, TimeUnit timeUnit) {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference ref = new AtomicReference();
        SpaceAddedEventListener added = new SpaceAddedEventListener(){

            @Override
            public void spaceAdded(Space space) {
                if (space.getName().equals(spaceName)) {
                    ref.set(space);
                    latch.countDown();
                }
            }
        };
        this.getSpaceAdded().add(added);
        try {
            latch.await(timeout, timeUnit);
            Space space = (Space)ref.get();
            return space;
        }
        catch (InterruptedException e) {
            Space space = null;
            return space;
        }
        finally {
            this.getSpaceAdded().remove(added);
        }
    }

    @Override
    public void addLifecycleListener(SpaceLifecycleEventListener eventListener) {
        this.getSpaceAdded().add(eventListener);
        this.getSpaceRemoved().add(eventListener);
    }

    @Override
    public void removeLifecycleListener(SpaceLifecycleEventListener eventListener) {
        this.getSpaceAdded().remove(eventListener);
        this.getSpaceRemoved().remove(eventListener);
    }

    @Override
    public SpaceModeChangedEventManager getSpaceModeChanged() {
        return this.spaceModeChangedEventManager;
    }

    @Override
    public SpaceSuspendTypeChangedEventManager getSpaceSuspendTypeChanged() {
        return this.spaceSuspendTypeChangedEventManager;
    }

    @Override
    public ReplicationStatusChangedEventManager getReplicationStatusChanged() {
        return this.replicationStatusChangedEventManager;
    }

    @Override
    public SpaceInstance[] getSpaceInstances() {
        ArrayList<SpaceInstance> spaceInstances = new ArrayList<SpaceInstance>();
        for (Space space : this) {
            for (SpaceInstance spaceInstance : space) {
                spaceInstances.add(spaceInstance);
            }
        }
        return spaceInstances.toArray(new SpaceInstance[spaceInstances.size()]);
    }

    @Override
    public SpaceInstanceAddedEventManager getSpaceInstanceAdded() {
        return this.spaceInstanceAddedEventManager;
    }

    @Override
    public SpaceInstanceRemovedEventManager getSpaceInstanceRemoved() {
        return this.spaceInstanceRemovedEventManager;
    }

    @Override
    public void addLifecycleListener(SpaceInstanceLifecycleEventListener eventListener) {
        this.spaceInstanceAddedEventManager.add(eventListener);
        this.spaceInstanceRemovedEventManager.add(eventListener);
    }

    @Override
    public void removeLifecycleListener(SpaceInstanceLifecycleEventListener eventListener) {
        this.spaceInstanceAddedEventManager.remove(eventListener);
        this.spaceInstanceRemovedEventManager.remove(eventListener);
    }

    @Override
    public synchronized void addSpace(final Space space) {
        this.assertStateChangesPermitted();
        Space existingSpace = this.spacesByUID.put(space.getUid(), space);
        this.spacesByName.put(space.getName(), space);
        if (existingSpace == null) {
            this.spaceAddedEventManager.spaceAdded(space);
        }
        space.setStatisticsInterval(this.statisticsInterval, TimeUnit.MILLISECONDS);
        space.setStatisticsHistorySize(this.statisticsHistorySize);
        if (this.isMonitoring()) {
            this.admin.raiseEvent(this, new Runnable(){

                @Override
                public void run() {
                    space.startStatisticsMonitor();
                }
            });
        }
    }

    @Override
    public synchronized InternalSpace removeSpace(String uid) {
        this.assertStateChangesPermitted();
        Space space = this.spacesByUID.remove(uid);
        if (space != null) {
            space.stopStatisticsMonitor();
            this.spacesByName.remove(space.getName());
            this.spaceRemovedEventManager.spaceRemoved(space);
        }
        return (InternalSpace)space;
    }

    @Override
    public void addSpaceInstance(SpaceInstance spaceInstance) {
        this.assertStateChangesPermitted();
        this.spacesInstances.put(spaceInstance.getUid(), spaceInstance);
    }

    @Override
    public SpaceInstance removeSpaceInstance(String uid) {
        this.assertStateChangesPermitted();
        return this.spacesInstances.remove(uid);
    }

    @Override
    public void refreshScheduledSpaceMonitors() {
        for (Space space : this) {
            ((InternalSpace)space).refreshScheduledSpaceMonitors();
        }
    }

    private void assertStateChangesPermitted() {
        this.admin.assertStateChangesPermitted();
    }
}

