/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.space;

import com.gigaspaces.time.SystemTime;
import java.rmi.RemoteException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.admin.internal.admin.DefaultAdmin;

public abstract class RemoteOperationTimeBasedCache<T> {
    private static final Log logger = LogFactory.getLog(DefaultAdmin.class);
    private final Object monitor = new Object();
    private final long statisticsInterval = 5000L;
    private long lastStatisticsTimestamp = 0L;
    private volatile T lastInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() {
        Object object = this.monitor;
        synchronized (object) {
            long currentTime = SystemTime.timeMillis();
            if (currentTime - this.lastStatisticsTimestamp < 5000L) {
                return this.lastInstance;
            }
            this.lastStatisticsTimestamp = currentTime;
            try {
                this.lastInstance = this.load();
            }
            catch (RemoteException e) {
                logger.debug((Object)"RemoteException caught while trying to retrieve Space Runtime Info from space admin.", (Throwable)e);
                return null;
            }
            return this.lastInstance;
        }
    }

    protected abstract T load() throws RemoteException;
}

