/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.space.events;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.space.events.ClosureReplicationStatusChangedEventListener;
import org.openspaces.admin.internal.space.events.InternalReplicationStatusChangedEventManager;
import org.openspaces.admin.internal.support.GroovyHelper;
import org.openspaces.admin.space.ReplicationTarget;
import org.openspaces.admin.space.Space;
import org.openspaces.admin.space.SpaceInstance;
import org.openspaces.admin.space.events.ReplicationStatusChangedEvent;
import org.openspaces.admin.space.events.ReplicationStatusChangedEventListener;

public class DefaultReplicationStatusChangedEventManager
implements InternalReplicationStatusChangedEventManager {
    private final InternalAdmin admin;
    private final List<ReplicationStatusChangedEventListener> listeners = new CopyOnWriteArrayList<ReplicationStatusChangedEventListener>();

    public DefaultReplicationStatusChangedEventManager(InternalAdmin admin) {
        this.admin = admin;
    }

    @Override
    public void replicationStatusChanged(final ReplicationStatusChangedEvent event) {
        for (final ReplicationStatusChangedEventListener listener : this.listeners) {
            this.admin.raiseEvent(listener, new Runnable(){

                @Override
                public void run() {
                    listener.replicationStatusChanged(event);
                }
            });
        }
    }

    @Override
    public void add(final ReplicationStatusChangedEventListener eventListener) {
        for (Space space : this.admin.getSpaces().getSpaces()) {
            for (SpaceInstance spaceInstance : space.getInstances()) {
                for (ReplicationTarget replicationTarget : spaceInstance.getReplicationTargets()) {
                    final ReplicationStatusChangedEvent event = new ReplicationStatusChangedEvent(spaceInstance, replicationTarget, null, replicationTarget.getReplicationStatus());
                    this.admin.raiseEvent(eventListener, new Runnable(){

                        @Override
                        public void run() {
                            eventListener.replicationStatusChanged(event);
                        }
                    });
                }
            }
        }
        this.listeners.add(eventListener);
    }

    @Override
    public void remove(ReplicationStatusChangedEventListener eventListener) {
        this.listeners.remove(eventListener);
    }

    public void plus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.add(new ClosureReplicationStatusChangedEventListener(eventListener));
        } else {
            this.add((ReplicationStatusChangedEventListener)eventListener);
        }
    }

    public void leftShift(Object eventListener) {
        this.plus(eventListener);
    }

    public void minus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.remove(new ClosureReplicationStatusChangedEventListener(eventListener));
        } else {
            this.remove((ReplicationStatusChangedEventListener)eventListener);
        }
    }

    public void rightShift(Object eventListener) {
        this.minus(eventListener);
    }
}

