/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.space.events;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.space.InternalSpaces;
import org.openspaces.admin.internal.space.events.ClosureSpaceAddedEventListener;
import org.openspaces.admin.internal.space.events.InternalSpaceAddedEventManager;
import org.openspaces.admin.internal.support.GroovyHelper;
import org.openspaces.admin.space.Space;
import org.openspaces.admin.space.events.SpaceAddedEventListener;

public class DefaultSpaceAddedEventManager
implements InternalSpaceAddedEventManager {
    private final InternalSpaces spaces;
    private final InternalAdmin admin;
    private final List<SpaceAddedEventListener> listeners = new CopyOnWriteArrayList<SpaceAddedEventListener>();

    public DefaultSpaceAddedEventManager(InternalSpaces spaces) {
        this.spaces = spaces;
        this.admin = (InternalAdmin)spaces.getAdmin();
    }

    @Override
    public void spaceAdded(final Space space) {
        for (final SpaceAddedEventListener listener : this.listeners) {
            this.admin.pushScheduleMonitorCorrelatedEvent(listener, new Runnable(){

                @Override
                public void run() {
                    listener.spaceAdded(space);
                }
            });
        }
    }

    @Override
    public void add(final SpaceAddedEventListener eventListener) {
        this.admin.raiseEvent(eventListener, new Runnable(){

            @Override
            public void run() {
                for (Space space : DefaultSpaceAddedEventManager.this.spaces) {
                    eventListener.spaceAdded(space);
                }
            }
        });
        this.listeners.add(eventListener);
    }

    @Override
    public void add(final SpaceAddedEventListener eventListener, boolean includeExisting) {
        if (includeExisting) {
            this.admin.raiseEvent(eventListener, new Runnable(){

                @Override
                public void run() {
                    for (Space space : DefaultSpaceAddedEventManager.this.spaces) {
                        eventListener.spaceAdded(space);
                    }
                }
            });
        }
        this.listeners.add(eventListener);
    }

    @Override
    public void remove(SpaceAddedEventListener eventListener) {
        this.listeners.remove(eventListener);
    }

    public void plus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.add(new ClosureSpaceAddedEventListener(eventListener));
        } else {
            this.add((SpaceAddedEventListener)eventListener);
        }
    }

    public void leftShift(Object eventListener) {
        this.plus(eventListener);
    }

    public void minus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.remove(new ClosureSpaceAddedEventListener(eventListener));
        } else {
            this.remove((SpaceAddedEventListener)eventListener);
        }
    }

    public void rightShift(Object eventListener) {
        this.minus(eventListener);
    }
}

