/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.space.events;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.space.InternalSpaceInstancesAware;
import org.openspaces.admin.internal.space.events.ClosureSpaceInstanceAddedEventListener;
import org.openspaces.admin.internal.space.events.InternalSpaceInstanceAddedEventManager;
import org.openspaces.admin.internal.support.GroovyHelper;
import org.openspaces.admin.space.SpaceInstance;
import org.openspaces.admin.space.events.SpaceInstanceAddedEventListener;

public class DefaultSpaceInstanceAddedEventManager
implements InternalSpaceInstanceAddedEventManager {
    private final InternalSpaceInstancesAware spaceInstances;
    private final InternalAdmin admin;
    private final List<SpaceInstanceAddedEventListener> listeners = new CopyOnWriteArrayList<SpaceInstanceAddedEventListener>();

    public DefaultSpaceInstanceAddedEventManager(InternalAdmin admin, InternalSpaceInstancesAware spaceInstances) {
        this.admin = admin;
        this.spaceInstances = spaceInstances;
    }

    @Override
    public void spaceInstanceAdded(final SpaceInstance spaceInstance) {
        for (final SpaceInstanceAddedEventListener listener : this.listeners) {
            this.admin.pushScheduleMonitorCorrelatedEvent(listener, new Runnable(){

                @Override
                public void run() {
                    listener.spaceInstanceAdded(spaceInstance);
                }
            });
        }
    }

    @Override
    public void add(final SpaceInstanceAddedEventListener eventListener, boolean includeExisting) {
        if (includeExisting) {
            this.admin.raiseEvent(eventListener, new Runnable(){

                @Override
                public void run() {
                    for (SpaceInstance spaceInstance : DefaultSpaceInstanceAddedEventManager.this.spaceInstances.getSpaceInstances()) {
                        eventListener.spaceInstanceAdded(spaceInstance);
                    }
                }
            });
        }
        this.listeners.add(eventListener);
    }

    @Override
    public void add(SpaceInstanceAddedEventListener eventListener) {
        this.add(eventListener, true);
    }

    @Override
    public void remove(SpaceInstanceAddedEventListener eventListener) {
        this.listeners.remove(eventListener);
    }

    public void plus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.add(new ClosureSpaceInstanceAddedEventListener(eventListener));
        } else {
            this.add((SpaceInstanceAddedEventListener)eventListener);
        }
    }

    public void leftShift(Object eventListener) {
        this.plus(eventListener);
    }

    public void minus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.remove(new ClosureSpaceInstanceAddedEventListener(eventListener));
        } else {
            this.remove((SpaceInstanceAddedEventListener)eventListener);
        }
    }

    public void rightShift(Object eventListener) {
        this.minus(eventListener);
    }
}

