/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.space.events;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.space.events.ClosureInstanceSpaceRemovedEventListener;
import org.openspaces.admin.internal.space.events.InternalSpaceInstanceRemovedEventManager;
import org.openspaces.admin.internal.support.GroovyHelper;
import org.openspaces.admin.space.SpaceInstance;
import org.openspaces.admin.space.events.SpaceInstanceRemovedEventListener;

public class DefaultSpaceInstanceRemovedEventManager
implements InternalSpaceInstanceRemovedEventManager {
    private final InternalAdmin admin;
    private final List<SpaceInstanceRemovedEventListener> listeners = new CopyOnWriteArrayList<SpaceInstanceRemovedEventListener>();

    public DefaultSpaceInstanceRemovedEventManager(InternalAdmin admin) {
        this.admin = admin;
    }

    @Override
    public void spaceInstanceRemoved(final SpaceInstance spaceInstance) {
        for (final SpaceInstanceRemovedEventListener listener : this.listeners) {
            this.admin.pushScheduleMonitorCorrelatedEvent(listener, new Runnable(){

                @Override
                public void run() {
                    listener.spaceInstanceRemoved(spaceInstance);
                }
            });
        }
    }

    @Override
    public void add(SpaceInstanceRemovedEventListener eventListener) {
        this.listeners.add(eventListener);
    }

    @Override
    public void remove(SpaceInstanceRemovedEventListener eventListener) {
        this.listeners.remove(eventListener);
    }

    public void plus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.add(new ClosureInstanceSpaceRemovedEventListener(eventListener));
        } else {
            this.add((SpaceInstanceRemovedEventListener)eventListener);
        }
    }

    public void leftShift(Object eventListener) {
        this.plus(eventListener);
    }

    public void minus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.remove(new ClosureInstanceSpaceRemovedEventListener(eventListener));
        } else {
            this.remove((SpaceInstanceRemovedEventListener)eventListener);
        }
    }

    public void rightShift(Object eventListener) {
        this.minus(eventListener);
    }
}

