/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.space.events;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.space.events.ClosureSpaceInstanceStatisticsChangedEventListener;
import org.openspaces.admin.internal.space.events.InternalSpaceInstanceStatisticsChangedEventManager;
import org.openspaces.admin.internal.support.GroovyHelper;
import org.openspaces.admin.space.events.SpaceInstanceStatisticsChangedEvent;
import org.openspaces.admin.space.events.SpaceInstanceStatisticsChangedEventListener;

public class DefaultSpaceInstanceStatisticsChangedEventManager
implements InternalSpaceInstanceStatisticsChangedEventManager {
    private final InternalAdmin admin;
    private final List<SpaceInstanceStatisticsChangedEventListener> listeners = new CopyOnWriteArrayList<SpaceInstanceStatisticsChangedEventListener>();

    public DefaultSpaceInstanceStatisticsChangedEventManager(InternalAdmin admin) {
        this.admin = admin;
    }

    @Override
    public void spaceInstanceStatisticsChanged(final SpaceInstanceStatisticsChangedEvent event) {
        for (final SpaceInstanceStatisticsChangedEventListener listener : this.listeners) {
            this.admin.raiseEvent(listener, new Runnable(){

                @Override
                public void run() {
                    listener.spaceInstanceStatisticsChanged(event);
                }
            });
        }
    }

    @Override
    public void add(SpaceInstanceStatisticsChangedEventListener eventListener) {
        this.listeners.add(eventListener);
    }

    @Override
    public void remove(SpaceInstanceStatisticsChangedEventListener eventListener) {
        this.listeners.remove(eventListener);
    }

    public void plus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.add(new ClosureSpaceInstanceStatisticsChangedEventListener(eventListener));
        } else {
            this.add((SpaceInstanceStatisticsChangedEventListener)eventListener);
        }
    }

    public void leftShift(Object eventListener) {
        this.plus(eventListener);
    }

    public void minus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.remove(new ClosureSpaceInstanceStatisticsChangedEventListener(eventListener));
        } else {
            this.remove((SpaceInstanceStatisticsChangedEventListener)eventListener);
        }
    }

    public void rightShift(Object eventListener) {
        this.minus(eventListener);
    }
}

