/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.space.events;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.space.InternalSpaceInstancesAware;
import org.openspaces.admin.internal.space.events.ClosureSpaceModeChangedEventListener;
import org.openspaces.admin.internal.space.events.InternalSpaceModeChangedEventManager;
import org.openspaces.admin.internal.support.GroovyHelper;
import org.openspaces.admin.space.SpaceInstance;
import org.openspaces.admin.space.events.SpaceModeChangedEvent;
import org.openspaces.admin.space.events.SpaceModeChangedEventListener;

public class DefaultSpaceModeChangedEventManager
implements InternalSpaceModeChangedEventManager {
    private final InternalAdmin admin;
    private final InternalSpaceInstancesAware spaceInstances;
    private final List<SpaceModeChangedEventListener> listeners = new CopyOnWriteArrayList<SpaceModeChangedEventListener>();

    public DefaultSpaceModeChangedEventManager(InternalSpaceInstancesAware spaceInstances, InternalAdmin admin) {
        this.spaceInstances = spaceInstances;
        this.admin = admin;
    }

    @Override
    public void spaceModeChanged(final SpaceModeChangedEvent event) {
        for (final SpaceModeChangedEventListener listener : this.listeners) {
            this.admin.raiseEvent(listener, new Runnable(){

                @Override
                public void run() {
                    listener.spaceModeChanged(event);
                }
            });
        }
    }

    @Override
    public void add(final SpaceModeChangedEventListener eventListener) {
        if (this.spaceInstances != null) {
            SpaceInstance[] instances = this.spaceInstances.getSpaceInstances();
            this.listeners.add(eventListener);
            for (final SpaceInstance spaceInstance : instances) {
                this.admin.raiseEvent(eventListener, new Runnable(){

                    @Override
                    public void run() {
                        eventListener.spaceModeChanged(new SpaceModeChangedEvent(spaceInstance, null, spaceInstance.getMode()));
                    }
                });
            }
        } else {
            this.listeners.add(eventListener);
        }
    }

    @Override
    public void remove(SpaceModeChangedEventListener eventListener) {
        this.listeners.remove(eventListener);
    }

    public void plus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.add(new ClosureSpaceModeChangedEventListener(eventListener));
        } else {
            this.add((SpaceModeChangedEventListener)eventListener);
        }
    }

    public void leftShift(Object eventListener) {
        this.plus(eventListener);
    }

    public void minus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.remove(new ClosureSpaceModeChangedEventListener(eventListener));
        } else {
            this.remove((SpaceModeChangedEventListener)eventListener);
        }
    }

    public void rightShift(Object eventListener) {
        this.minus(eventListener);
    }
}

