/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.space.events;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.space.InternalSpaces;
import org.openspaces.admin.internal.space.events.ClosureSpaceRemovedEventListener;
import org.openspaces.admin.internal.space.events.InternalSpaceRemovedEventManager;
import org.openspaces.admin.internal.support.GroovyHelper;
import org.openspaces.admin.space.Space;
import org.openspaces.admin.space.events.SpaceRemovedEventListener;

public class DefaultSpaceRemovedEventManager
implements InternalSpaceRemovedEventManager {
    private final InternalSpaces spaces;
    private final InternalAdmin admin;
    private final List<SpaceRemovedEventListener> listeners = new CopyOnWriteArrayList<SpaceRemovedEventListener>();

    public DefaultSpaceRemovedEventManager(InternalSpaces spaces) {
        this.spaces = spaces;
        this.admin = (InternalAdmin)spaces.getAdmin();
    }

    @Override
    public void spaceRemoved(final Space space) {
        for (final SpaceRemovedEventListener listener : this.listeners) {
            this.admin.pushScheduleMonitorCorrelatedEvent(listener, new Runnable(){

                @Override
                public void run() {
                    listener.spaceRemoved(space);
                }
            });
        }
    }

    @Override
    public void add(SpaceRemovedEventListener eventListener) {
        this.listeners.add(eventListener);
    }

    @Override
    public void remove(SpaceRemovedEventListener eventListener) {
        this.listeners.remove(eventListener);
    }

    public void plus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.add(new ClosureSpaceRemovedEventListener(eventListener));
        } else {
            this.add((SpaceRemovedEventListener)eventListener);
        }
    }

    public void leftShift(Object eventListener) {
        this.plus(eventListener);
    }

    public void minus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.remove(new ClosureSpaceRemovedEventListener(eventListener));
        } else {
            this.remove((SpaceRemovedEventListener)eventListener);
        }
    }

    public void rightShift(Object eventListener) {
        this.minus(eventListener);
    }
}

