/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.space.events;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.space.events.ClosureSpaceStatisticsChangedEventListener;
import org.openspaces.admin.internal.space.events.InternalSpaceStatisticsChangedEventManager;
import org.openspaces.admin.internal.support.GroovyHelper;
import org.openspaces.admin.space.events.SpaceStatisticsChangedEvent;
import org.openspaces.admin.space.events.SpaceStatisticsChangedEventListener;

public class DefaultSpaceStatisticsChangedEventManager
implements InternalSpaceStatisticsChangedEventManager {
    private final InternalAdmin admin;
    private final List<SpaceStatisticsChangedEventListener> listeners = new CopyOnWriteArrayList<SpaceStatisticsChangedEventListener>();

    public DefaultSpaceStatisticsChangedEventManager(InternalAdmin admin) {
        this.admin = admin;
    }

    @Override
    public void spaceStatisticsChanged(final SpaceStatisticsChangedEvent event) {
        for (final SpaceStatisticsChangedEventListener listener : this.listeners) {
            this.admin.raiseEvent(listener, new Runnable(){

                @Override
                public void run() {
                    listener.spaceStatisticsChanged(event);
                }
            });
        }
    }

    @Override
    public void add(SpaceStatisticsChangedEventListener eventListener) {
        this.listeners.add(eventListener);
    }

    @Override
    public void remove(SpaceStatisticsChangedEventListener eventListener) {
        this.listeners.remove(eventListener);
    }

    public void plus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.add(new ClosureSpaceStatisticsChangedEventListener(eventListener));
        } else {
            this.add((SpaceStatisticsChangedEventListener)eventListener);
        }
    }

    public void leftShift(Object eventListener) {
        this.plus(eventListener);
    }

    public void minus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.remove(new ClosureSpaceStatisticsChangedEventListener(eventListener));
        } else {
            this.remove((SpaceStatisticsChangedEventListener)eventListener);
        }
    }

    public void rightShift(Object eventListener) {
        this.minus(eventListener);
    }
}

