/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.space.events;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.space.InternalSpaceInstancesAware;
import org.openspaces.admin.internal.space.events.InternalSpaceSuspendTypeChangedEventManager;
import org.openspaces.admin.space.SpaceInstance;
import org.openspaces.admin.space.events.SpaceSuspendTypeChangedEvent;
import org.openspaces.admin.space.events.SpaceSuspendTypeChangedEventListener;

public class DefaultSpaceSuspendTypeChangedEventManager
implements InternalSpaceSuspendTypeChangedEventManager {
    private final InternalAdmin admin;
    private final InternalSpaceInstancesAware spaceInstances;
    private final List<SpaceSuspendTypeChangedEventListener> listeners = new CopyOnWriteArrayList<SpaceSuspendTypeChangedEventListener>();

    public DefaultSpaceSuspendTypeChangedEventManager(InternalSpaceInstancesAware spaceInstances, InternalAdmin admin) {
        this.spaceInstances = spaceInstances;
        this.admin = admin;
    }

    @Override
    public void spaceSuspendTypeChanged(final SpaceSuspendTypeChangedEvent event) {
        for (final SpaceSuspendTypeChangedEventListener listener : this.listeners) {
            this.admin.raiseEvent(listener, new Runnable(){

                @Override
                public void run() {
                    listener.spaceSuspendTypeChanged(event);
                }
            });
        }
    }

    @Override
    public void add(final SpaceSuspendTypeChangedEventListener eventListener) {
        if (this.spaceInstances != null) {
            SpaceInstance[] instances = this.spaceInstances.getSpaceInstances();
            this.listeners.add(eventListener);
            for (final SpaceInstance spaceInstance : instances) {
                this.admin.raiseEvent(eventListener, new Runnable(){

                    @Override
                    public void run() {
                        eventListener.spaceSuspendTypeChanged(new SpaceSuspendTypeChangedEvent(spaceInstance, null, spaceInstance.getSuspendInfo().getSuspendType()));
                    }
                });
            }
        } else {
            this.listeners.add(eventListener);
        }
    }

    @Override
    public void remove(SpaceSuspendTypeChangedEventListener eventListener) {
        this.listeners.remove(eventListener);
    }
}

