/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.statistics;

import com.gigaspaces.time.SystemTime;
import java.util.concurrent.atomic.AtomicReference;

public class LastStatisticsHolder<S> {
    private volatile long lastStatisticsTimestamp = 0L;
    private AtomicReference<Object> lastStatisticsLock = new AtomicReference();
    private volatile S lastStatistics;

    public LastStatisticsHolder() {
        this.lastStatistics = null;
    }

    public LastStatisticsHolder(S lastStatistics) {
        this.lastStatistics = lastStatistics;
    }

    public boolean validCache(long statisticsInterval) {
        long currentTime = SystemTime.timeMillis();
        return currentTime - this.lastStatisticsTimestamp < statisticsInterval;
    }

    public boolean acquireLastStatisticsLock() {
        boolean acquired = this.lastStatisticsLock.compareAndSet(null, this);
        return acquired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLastStatisticsLock() {
        boolean set = this.lastStatisticsLock.compareAndSet(this, null);
        if (!set) {
            return;
        }
        AtomicReference<Object> atomicReference = this.lastStatisticsLock;
        synchronized (atomicReference) {
            this.lastStatisticsLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForLastStatistics() {
        AtomicReference<Object> atomicReference = this.lastStatisticsLock;
        synchronized (atomicReference) {
            try {
                this.lastStatisticsLock.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void updateLastStatistics(S lastStatistics) {
        this.lastStatisticsTimestamp = SystemTime.timeMillis();
        if (lastStatistics != null) {
            this.lastStatistics = lastStatistics;
        }
    }

    public S getLastStatistics() {
        return this.lastStatistics;
    }
}

