/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.statistics;

import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class ScheduledStatisticsHolder {
    private Future scheduledStatisticsMonitor;
    private int scheduledStatisticsRefCount = 0;
    private volatile long statisticsInterval = 5000L;
    private volatile int statisticsHistorySize = 120;

    public long getStatisticsInterval() {
        return this.statisticsInterval;
    }

    public void updateStatisticsInterval(long interval, TimeUnit timeUnit) {
        this.statisticsInterval = timeUnit.toMillis(interval);
    }

    public int getStatisticsHistorySize() {
        return this.statisticsHistorySize;
    }

    public void updateStatisticsHistorySize(int statisticsHistorySize) {
        this.statisticsHistorySize = statisticsHistorySize;
    }

    public void cancelMonitor(boolean mayInterruptIfRunning) {
        this.scheduledStatisticsMonitor.cancel(mayInterruptIfRunning);
    }

    public void updateMonitor(ScheduledFuture<?> scheduledFuture) {
        this.scheduledStatisticsMonitor = scheduledFuture;
    }

    public int getAndIncrementRefCount() {
        return this.scheduledStatisticsRefCount++;
    }

    public int decrementAndGetRefCount() {
        if (this.scheduledStatisticsRefCount == 0) {
            return 0;
        }
        return --this.scheduledStatisticsRefCount;
    }

    public boolean isMonitoring() {
        return this.scheduledStatisticsMonitor != null;
    }
}

