/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.support;

import com.gigaspaces.internal.jvm.JVMDetails;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.openspaces.admin.Admin;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.support.InternalGridComponent;
import org.openspaces.admin.machine.Machine;
import org.openspaces.admin.os.OperatingSystem;
import org.openspaces.admin.transport.Transport;
import org.openspaces.admin.vm.VirtualMachine;
import org.openspaces.admin.zone.Zone;

public abstract class AbstractGridComponent
implements InternalGridComponent {
    protected final InternalAdmin admin;
    private volatile Machine machine;
    private volatile Transport transport;
    private volatile OperatingSystem operatingSystem;
    private volatile VirtualMachine virtualMachine;
    private volatile boolean discovered = true;
    private final Map<String, Zone> zones = new ConcurrentHashMap<String, Zone>();
    private final JVMDetails jvmDetails;

    protected AbstractGridComponent(InternalAdmin admin, JVMDetails jvmDetails) {
        this.admin = admin;
        this.jvmDetails = jvmDetails;
    }

    @Override
    public Admin getAdmin() {
        return this.admin;
    }

    @Override
    public void setMachine(Machine machine) {
        this.assertStateChangesPermitted();
        this.machine = machine;
    }

    @Override
    public Machine getMachine() {
        return this.machine;
    }

    @Override
    public void setTransport(Transport transport) {
        this.assertStateChangesPermitted();
        this.transport = transport;
    }

    @Override
    public Transport getTransport() {
        return this.transport;
    }

    @Override
    public void setOperatingSystem(OperatingSystem operatingSystem) {
        this.assertStateChangesPermitted();
        this.operatingSystem = operatingSystem;
    }

    @Override
    public OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    @Override
    public void setVirtualMachine(VirtualMachine virtualMachine) {
        this.assertStateChangesPermitted();
        this.virtualMachine = virtualMachine;
    }

    @Override
    public VirtualMachine getVirtualMachine() {
        return this.virtualMachine;
    }

    @Override
    public boolean isDiscovered() {
        return this.discovered;
    }

    @Override
    public void setDiscovered(boolean discovered) {
        this.assertStateChangesPermitted();
        this.discovered = discovered;
    }

    @Override
    public Map<String, Zone> getZones() {
        return Collections.unmodifiableMap(this.zones);
    }

    @Override
    public void addZone(Zone zone) {
        this.assertStateChangesPermitted();
        this.zones.put(zone.getName(), zone);
    }

    protected void assertStateChangesPermitted() {
        this.admin.assertStateChangesPermitted();
    }

    @Override
    public JVMDetails getJVMDetails() {
        return this.jvmDetails;
    }
}

