/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.support;

import com.gigaspaces.exception.lrmi.LRMINoSuchObjectException;
import java.io.IOException;
import java.net.ConnectException;
import java.nio.channels.ClosedChannelException;

public abstract class NetworkExceptionHelper {
    public static boolean isConnectOrCloseException(Throwable e) {
        if (e instanceof java.rmi.ConnectException && e.getCause() != null && e.getCause() instanceof IOException) {
            if (e.getCause() instanceof ClosedChannelException || e.getCause() instanceof ConnectException) {
                return true;
            }
            if (e.getCause().getMessage() != null && e.getCause().getMessage().contains("aborted")) {
                return true;
            }
            if (e.getCause().getMessage() != null && e.getCause().getMessage().contains("Connection reset by peer")) {
                return true;
            }
            if (e.getCause().getMessage() != null && e.getCause().getMessage().contains("Connection refused")) {
                return true;
            }
        }
        if (e instanceof LRMINoSuchObjectException) {
            return true;
        }
        return e instanceof IOException && e.getMessage() != null && e.getMessage().startsWith("Connection reset by peer");
    }
}

