/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.transport;

import com.gigaspaces.lrmi.LRMIInboundMonitoringDetails;
import com.gigaspaces.lrmi.LRMIMonitoringDetails;
import com.gigaspaces.lrmi.LRMIOutboundMonitoringDetails;
import com.gigaspaces.lrmi.LRMIProxyMonitoringDetails;
import com.gigaspaces.lrmi.LRMIServiceMonitoringDetails;
import com.gigaspaces.lrmi.nio.info.NIODetails;
import java.rmi.RemoteException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.openspaces.admin.AdminException;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.statistics.LastStatisticsHolder;
import org.openspaces.admin.internal.statistics.ScheduledStatisticsHolder;
import org.openspaces.admin.internal.transport.DefaultTransportDetails;
import org.openspaces.admin.internal.transport.DefaultTransportStatistics;
import org.openspaces.admin.internal.transport.InternalTransport;
import org.openspaces.admin.internal.transport.InternalTransportInfoProvider;
import org.openspaces.admin.internal.transport.InternalTransports;
import org.openspaces.admin.internal.transport.events.DefaultTransportStatisticsChangedEventManager;
import org.openspaces.admin.internal.transport.events.InternalTransportStatisticsChangedEventManager;
import org.openspaces.admin.transport.TransportDetails;
import org.openspaces.admin.transport.TransportLRMIMonitoring;
import org.openspaces.admin.transport.TransportStatistics;
import org.openspaces.admin.transport.events.TransportStatisticsChangedEvent;
import org.openspaces.admin.transport.events.TransportStatisticsChangedEventManager;
import org.openspaces.admin.vm.VirtualMachine;
import org.openspaces.core.util.ConcurrentHashSet;

public class DefaultTransport
implements InternalTransport,
TransportLRMIMonitoring {
    private final String uid;
    private final TransportDetails transportDetails;
    private final InternalTransports transports;
    private final InternalAdmin admin;
    private final Set<InternalTransportInfoProvider> transportInfoProviders = new ConcurrentHashSet();
    private volatile VirtualMachine virtualMachine;
    private final LastStatisticsHolder<TransportStatistics> lastStatisticsHolder = new LastStatisticsHolder<DefaultTransportStatistics>(new DefaultTransportStatistics());
    private final ScheduledStatisticsHolder scheduledStatisticsHolder = new ScheduledStatisticsHolder();
    private final InternalTransportStatisticsChangedEventManager statisticsChangedEventManager;

    public DefaultTransport(NIODetails nioDetails, InternalTransports transports) {
        this.transportDetails = new DefaultTransportDetails(nioDetails);
        this.uid = this.getBindHost() + ":" + this.getPort();
        this.transports = transports;
        this.admin = (InternalAdmin)transports.getAdmin();
        this.statisticsChangedEventManager = new DefaultTransportStatisticsChangedEventManager(this.admin);
    }

    @Override
    public TransportStatisticsChangedEventManager getStatisticsChanged() {
        return this.statisticsChangedEventManager;
    }

    @Override
    public void addTransportInfoProvider(InternalTransportInfoProvider transportInfoProvider) {
        this.assertStateChangesPermitted();
        this.transportInfoProviders.add(transportInfoProvider);
    }

    @Override
    public void removeTransportInfoProvider(InternalTransportInfoProvider transportInfoProvider) {
        this.assertStateChangesPermitted();
        this.transportInfoProviders.remove(transportInfoProvider);
    }

    @Override
    public boolean hasTransportInfoProviders() {
        return !this.transportInfoProviders.isEmpty();
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public String getHostAddress() {
        return this.transportDetails.getHostAddress();
    }

    @Override
    public String getHostName() {
        return this.transportDetails.getHostName();
    }

    @Override
    public String getBindHost() {
        return this.transportDetails.getBindHost();
    }

    @Override
    public int getPort() {
        return this.transportDetails.getPort();
    }

    @Override
    public TransportDetails getDetails() {
        return this.transportDetails;
    }

    @Override
    public void setVirtualMachine(VirtualMachine virtualMachine) {
        this.assertStateChangesPermitted();
        this.virtualMachine = virtualMachine;
    }

    @Override
    public VirtualMachine getVirtualMachine() {
        return this.virtualMachine;
    }

    @Override
    public TransportStatistics getStatistics() {
        if (this.lastStatisticsHolder.validCache(this.scheduledStatisticsHolder.getStatisticsInterval())) {
            return this.lastStatisticsHolder.getLastStatistics();
        }
        boolean acquired = this.lastStatisticsHolder.acquireLastStatisticsLock();
        if (acquired) {
            try {
                this.lastStatisticsHolder.updateLastStatistics(this.doGetStatistics());
            }
            finally {
                this.lastStatisticsHolder.releaseLastStatisticsLock();
            }
        } else if (this.lastStatisticsHolder.getLastStatistics().isNA()) {
            this.lastStatisticsHolder.waitForLastStatistics();
        }
        return this.lastStatisticsHolder.getLastStatistics();
    }

    private TransportStatistics doGetStatistics() {
        for (InternalTransportInfoProvider provider : this.transportInfoProviders) {
            try {
                if (this.getVirtualMachine().getMachine() == null) continue;
                TransportStatistics previousStats = this.lastStatisticsHolder.getLastStatistics();
                return new DefaultTransportStatistics(provider.getNIOStatistics(), previousStats, this.getDetails(), this.scheduledStatisticsHolder.getStatisticsHistorySize(), this.getVirtualMachine().getMachine().getOperatingSystem().getTimeDelta());
            }
            catch (RemoteException remoteException) {
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStatisticsInterval(long interval, TimeUnit timeUnit) {
        ScheduledStatisticsHolder scheduledStatisticsHolder = this.scheduledStatisticsHolder;
        synchronized (scheduledStatisticsHolder) {
            this.scheduledStatisticsHolder.updateStatisticsInterval(interval, timeUnit);
            if (this.scheduledStatisticsHolder.isMonitoring()) {
                this.stopStatisticsMonitor();
                this.startStatisticsMonitor();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStatisticsHistorySize(int historySize) {
        ScheduledStatisticsHolder scheduledStatisticsHolder = this.scheduledStatisticsHolder;
        synchronized (scheduledStatisticsHolder) {
            this.scheduledStatisticsHolder.updateStatisticsHistorySize(historySize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startStatisticsMonitor() {
        ScheduledStatisticsHolder scheduledStatisticsHolder = this.scheduledStatisticsHolder;
        synchronized (scheduledStatisticsHolder) {
            if (this.scheduledStatisticsHolder.getAndIncrementRefCount() > 0) {
                return;
            }
            if (this.scheduledStatisticsHolder.isMonitoring()) {
                this.scheduledStatisticsHolder.cancelMonitor(false);
            }
            final DefaultTransport transport = this;
            this.scheduledStatisticsHolder.updateMonitor(this.admin.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    TransportStatistics stats = transport.getStatistics();
                    TransportStatisticsChangedEvent event = new TransportStatisticsChangedEvent(transport, stats);
                    DefaultTransport.this.statisticsChangedEventManager.transportStatisticsChanged(event);
                    ((InternalTransportStatisticsChangedEventManager)DefaultTransport.this.transports.getTransportStatisticsChanged()).transportStatisticsChanged(event);
                }
            }, 0L, this.scheduledStatisticsHolder.getStatisticsInterval(), TimeUnit.MILLISECONDS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopStatisticsMonitor() {
        ScheduledStatisticsHolder scheduledStatisticsHolder = this.scheduledStatisticsHolder;
        synchronized (scheduledStatisticsHolder) {
            if (this.scheduledStatisticsHolder.decrementAndGetRefCount() > 0) {
                return;
            }
            if (this.scheduledStatisticsHolder.isMonitoring()) {
                this.scheduledStatisticsHolder.cancelMonitor(false);
                this.scheduledStatisticsHolder.updateMonitor(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isMonitoring() {
        ScheduledStatisticsHolder scheduledStatisticsHolder = this.scheduledStatisticsHolder;
        synchronized (scheduledStatisticsHolder) {
            return this.scheduledStatisticsHolder.isMonitoring();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultTransport that = (DefaultTransport)o;
        return this.uid.equals(that.uid);
    }

    public int hashCode() {
        return this.uid.hashCode();
    }

    private void assertStateChangesPermitted() {
        this.admin.assertStateChangesPermitted();
    }

    @Override
    public TransportLRMIMonitoring getLRMIMonitoring() {
        return this;
    }

    @Override
    public void enableMonitoring() {
        RemoteException lastException = null;
        for (InternalTransportInfoProvider transportProvider : this.transportInfoProviders) {
            try {
                transportProvider.enableLRMIMonitoring();
                lastException = null;
                break;
            }
            catch (RemoteException e) {
                lastException = e;
            }
        }
        if (lastException != null) {
            throw new AdminException(lastException.getMessage(), lastException);
        }
    }

    @Override
    public void disableMonitoring() {
        RemoteException lastException = null;
        for (InternalTransportInfoProvider transportProvider : this.transportInfoProviders) {
            try {
                transportProvider.disableLRMIMonitoring();
                lastException = null;
                break;
            }
            catch (RemoteException e) {
                lastException = e;
            }
        }
        if (lastException != null) {
            throw new AdminException(lastException.getMessage(), lastException);
        }
    }

    @Override
    public synchronized LRMIMonitoringDetails fetchMonitoringDetails() {
        Throwable lastException = null;
        for (InternalTransportInfoProvider transportProvider : this.transportInfoProviders) {
            try {
                return transportProvider.fetchLRMIMonitoringDetails();
            }
            catch (Exception e) {
                lastException = e;
            }
        }
        if (lastException != null) {
            throw new AdminException(lastException.getMessage(), lastException);
        }
        return new LRMIMonitoringDetails(){

            public LRMIOutboundMonitoringDetails getOutboundMonitoringDetails() {
                return new LRMIOutboundMonitoringDetails(){

                    public LRMIProxyMonitoringDetails[] getProxiesMonitoringDetails() {
                        return new LRMIProxyMonitoringDetails[0];
                    }
                };
            }

            public LRMIInboundMonitoringDetails getInboundMonitoringDetails() {
                return new LRMIInboundMonitoringDetails(){

                    public LRMIServiceMonitoringDetails[] getServicesMonitoringDetails() {
                        return new LRMIServiceMonitoringDetails[0];
                    }
                };
            }
        };
    }
}

