/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.transport;

import com.gigaspaces.lrmi.nio.info.NIOStatistics;
import org.openspaces.admin.support.StatisticsUtils;
import org.openspaces.admin.transport.TransportDetails;
import org.openspaces.admin.transport.TransportStatistics;

public class DefaultTransportStatistics
implements TransportStatistics {
    private static final NIOStatistics NA_STATS = new NIOStatistics();
    private final long timeDelta;
    private final NIOStatistics stats;
    private volatile TransportStatistics previousStats;
    private final TransportDetails details;

    public DefaultTransportStatistics() {
        this(NA_STATS, null, null, 0, -1L);
    }

    public DefaultTransportStatistics(NIOStatistics stats, TransportStatistics previousStats, TransportDetails details, int historySize, long timeDelta) {
        this.stats = stats;
        this.previousStats = previousStats;
        this.details = details;
        this.timeDelta = timeDelta;
        TransportStatistics lastStats = previousStats;
        if (lastStats != null) {
            for (int i = 0; i < historySize && lastStats.getPrevious() != null; ++i) {
                lastStats = lastStats.getPrevious();
            }
            ((DefaultTransportStatistics)lastStats).setPreviousStats(null);
        }
    }

    @Override
    public boolean isNA() {
        return this.stats.isNA();
    }

    @Override
    public long getTimestamp() {
        return this.stats.getTimestamp();
    }

    @Override
    public long getAdminTimestamp() {
        if (this.stats.getTimestamp() != -1L && this.timeDelta != Integer.MIN_VALUE) {
            return this.stats.getTimestamp() + this.timeDelta;
        }
        return -1L;
    }

    @Override
    public TransportDetails getDetails() {
        return this.details;
    }

    @Override
    public long getPreviousTimestamp() {
        if (this.previousStats == null) {
            return -1L;
        }
        return this.previousStats.getTimestamp();
    }

    @Override
    public TransportStatistics getPrevious() {
        return this.previousStats;
    }

    public void setPreviousStats(TransportStatistics previousStats) {
        this.previousStats = previousStats;
    }

    @Override
    public long getCompletedTaskCount() {
        return this.stats.getCompletedTaskCount();
    }

    @Override
    public double getCompletedTaskPerSecond() {
        if (this.previousStats == null) {
            return -1.0;
        }
        return StatisticsUtils.computePerSecond(this.getCompletedTaskCount(), this.getPrevious().getCompletedTaskCount(), this.getTimestamp(), this.getPreviousTimestamp());
    }

    @Override
    public int getActiveThreadsCount() {
        return this.stats.getActiveThreadsCount();
    }

    @Override
    public double getActiveThreadsPerc() {
        return StatisticsUtils.computePerc(this.getActiveThreadsCount(), this.getDetails().getMaxThreads());
    }

    @Override
    public int getQueueSize() {
        return this.stats.getQueueSize();
    }
}

