/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.transport;

import com.j_spaces.kernel.SizeConcurrentHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.openspaces.admin.Admin;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.statistics.LastStatisticsHolder;
import org.openspaces.admin.internal.statistics.ScheduledStatisticsHolder;
import org.openspaces.admin.internal.transport.DefaultTransportsDetails;
import org.openspaces.admin.internal.transport.DefaultTransportsStatistics;
import org.openspaces.admin.internal.transport.InternalTransports;
import org.openspaces.admin.internal.transport.events.DefaultTransportStatisticsChangedEventManager;
import org.openspaces.admin.internal.transport.events.DefaultTransportsStatisticsChangedEventManager;
import org.openspaces.admin.internal.transport.events.InternalTransportStatisticsChangedEventManager;
import org.openspaces.admin.internal.transport.events.InternalTransportsStatisticsChangedEventManager;
import org.openspaces.admin.transport.Transport;
import org.openspaces.admin.transport.TransportDetails;
import org.openspaces.admin.transport.TransportStatistics;
import org.openspaces.admin.transport.TransportsDetails;
import org.openspaces.admin.transport.TransportsStatistics;
import org.openspaces.admin.transport.events.TransportStatisticsChangedEventManager;
import org.openspaces.admin.transport.events.TransportsStatisticsChangedEvent;
import org.openspaces.admin.transport.events.TransportsStatisticsChangedEventManager;
import org.openspaces.core.util.ConcurrentHashSet;

public class DefaultTransports
implements InternalTransports {
    private final InternalAdmin admin;
    private final Map<String, Transport> transportsByUID = new SizeConcurrentHashMap();
    private final Map<String, Set<Transport>> transportsByHost = new SizeConcurrentHashMap();
    private final InternalTransportStatisticsChangedEventManager transportStatisticsChangedEventManager;
    private final InternalTransportsStatisticsChangedEventManager transportsStatisticsChangedEventManager;
    private final LastStatisticsHolder<TransportsStatistics> lastStatisticsHolder = new LastStatisticsHolder();
    private final ScheduledStatisticsHolder scheduledStatisticsHolder = new ScheduledStatisticsHolder();

    public DefaultTransports(InternalAdmin admin) {
        this.admin = admin;
        this.transportStatisticsChangedEventManager = new DefaultTransportStatisticsChangedEventManager(admin);
        this.transportsStatisticsChangedEventManager = new DefaultTransportsStatisticsChangedEventManager(admin);
    }

    @Override
    public Admin getAdmin() {
        return this.admin;
    }

    @Override
    public TransportStatisticsChangedEventManager getTransportStatisticsChanged() {
        return this.transportStatisticsChangedEventManager;
    }

    @Override
    public TransportsStatisticsChangedEventManager getStatisticsChanged() {
        return this.transportsStatisticsChangedEventManager;
    }

    @Override
    public Transport[] getTransports() {
        return this.transportsByUID.values().toArray(new Transport[0]);
    }

    @Override
    public Iterator<Transport> iterator() {
        return Collections.unmodifiableCollection(this.transportsByUID.values()).iterator();
    }

    @Override
    public Transport[] getTransports(String host) {
        Set<Transport> transportByHost = this.transportsByHost.get(host);
        if (transportByHost == null) {
            return new Transport[0];
        }
        return transportByHost.toArray(new Transport[0]);
    }

    @Override
    public Transport getTransportByHostAndPort(String host, int port) {
        return this.transportsByUID.get(host + ":" + port);
    }

    @Override
    public Transport getTransportByUID(String uid) {
        return this.transportsByUID.get(uid);
    }

    @Override
    public int getSize() {
        return this.transportsByUID.size();
    }

    @Override
    public TransportsDetails getDetails() {
        ArrayList<TransportDetails> details = new ArrayList<TransportDetails>();
        for (Transport transport : this.transportsByUID.values()) {
            details.add(transport.getDetails());
        }
        return new DefaultTransportsDetails(details.toArray(new TransportDetails[details.size()]));
    }

    @Override
    public TransportsStatistics getStatistics() {
        if (this.lastStatisticsHolder.validCache(this.scheduledStatisticsHolder.getStatisticsInterval())) {
            return this.lastStatisticsHolder.getLastStatistics();
        }
        boolean acquired = this.lastStatisticsHolder.acquireLastStatisticsLock();
        if (acquired) {
            try {
                this.lastStatisticsHolder.updateLastStatistics(this.doGetStatistics());
            }
            finally {
                this.lastStatisticsHolder.releaseLastStatisticsLock();
            }
        } else if (this.lastStatisticsHolder.getLastStatistics() == null) {
            this.lastStatisticsHolder.waitForLastStatistics();
        }
        return this.lastStatisticsHolder.getLastStatistics();
    }

    private TransportsStatistics doGetStatistics() {
        ArrayList<TransportStatistics> stats = new ArrayList<TransportStatistics>();
        ArrayList<TransportDetails> details = new ArrayList<TransportDetails>();
        for (Transport transport : this.transportsByUID.values()) {
            stats.add(transport.getStatistics());
            details.add(transport.getDetails());
        }
        TransportsStatistics previousStats = this.lastStatisticsHolder.getLastStatistics();
        return new DefaultTransportsStatistics(stats.toArray(new TransportStatistics[stats.size()]), previousStats, new DefaultTransportsDetails(details.toArray(new TransportDetails[details.size()])), this.scheduledStatisticsHolder.getStatisticsHistorySize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStatisticsInterval(long interval, TimeUnit timeUnit) {
        ScheduledStatisticsHolder scheduledStatisticsHolder = this.scheduledStatisticsHolder;
        synchronized (scheduledStatisticsHolder) {
            this.scheduledStatisticsHolder.updateStatisticsInterval(interval, timeUnit);
            if (this.scheduledStatisticsHolder.isMonitoring()) {
                this.rescheduleStatisticsMonitor();
            }
            for (Transport transport : this.transportsByUID.values()) {
                transport.setStatisticsInterval(interval, timeUnit);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStatisticsHistorySize(int historySize) {
        ScheduledStatisticsHolder scheduledStatisticsHolder = this.scheduledStatisticsHolder;
        synchronized (scheduledStatisticsHolder) {
            this.scheduledStatisticsHolder.updateStatisticsHistorySize(historySize);
            for (Transport transport : this.transportsByUID.values()) {
                transport.setStatisticsHistorySize(historySize);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startStatisticsMonitor() {
        ScheduledStatisticsHolder scheduledStatisticsHolder = this.scheduledStatisticsHolder;
        synchronized (scheduledStatisticsHolder) {
            this.rescheduleStatisticsMonitor();
            for (Transport transport : this.transportsByUID.values()) {
                transport.startStatisticsMonitor();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopStatisticsMonitor() {
        ScheduledStatisticsHolder scheduledStatisticsHolder = this.scheduledStatisticsHolder;
        synchronized (scheduledStatisticsHolder) {
            this.stopScheduledStatisticsMonitor();
            for (Transport transport : this.transportsByUID.values()) {
                transport.stopStatisticsMonitor();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopScheduledStatisticsMonitor() {
        ScheduledStatisticsHolder scheduledStatisticsHolder = this.scheduledStatisticsHolder;
        synchronized (scheduledStatisticsHolder) {
            if (this.scheduledStatisticsHolder.decrementAndGetRefCount() > 0) {
                return;
            }
            if (this.scheduledStatisticsHolder.isMonitoring()) {
                this.scheduledStatisticsHolder.cancelMonitor(false);
                this.scheduledStatisticsHolder.updateMonitor(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isMonitoring() {
        ScheduledStatisticsHolder scheduledStatisticsHolder = this.scheduledStatisticsHolder;
        synchronized (scheduledStatisticsHolder) {
            return this.scheduledStatisticsHolder.isMonitoring();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rescheduleStatisticsMonitor() {
        ScheduledStatisticsHolder scheduledStatisticsHolder = this.scheduledStatisticsHolder;
        synchronized (scheduledStatisticsHolder) {
            if (this.scheduledStatisticsHolder.getAndIncrementRefCount() > 0) {
                return;
            }
            if (this.scheduledStatisticsHolder.isMonitoring()) {
                this.scheduledStatisticsHolder.cancelMonitor(false);
            }
            this.scheduledStatisticsHolder.updateMonitor(this.admin.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    TransportsStatistics stats = DefaultTransports.this.getStatistics();
                    TransportsStatisticsChangedEvent event = new TransportsStatisticsChangedEvent(DefaultTransports.this, stats);
                    DefaultTransports.this.transportsStatisticsChangedEventManager.transportsStatisticsChanged(event);
                }
            }, 0L, this.scheduledStatisticsHolder.getStatisticsInterval(), TimeUnit.MILLISECONDS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTransport(final Transport transport) {
        ConcurrentHashSet transportByHost;
        this.assertStateChangesPermitted();
        Transport existingTransport = this.transportsByUID.put(transport.getUid(), transport);
        if (existingTransport == null && this.isMonitoring()) {
            this.admin.raiseEvent(this, new Runnable(){

                @Override
                public void run() {
                    transport.setStatisticsInterval(DefaultTransports.this.scheduledStatisticsHolder.getStatisticsInterval(), TimeUnit.MILLISECONDS);
                    transport.setStatisticsHistorySize(DefaultTransports.this.scheduledStatisticsHolder.getStatisticsHistorySize());
                    transport.startStatisticsMonitor();
                }
            });
        }
        if ((transportByHost = this.transportsByHost.get(transport.getBindHost())) == null) {
            Map<String, Set<Transport>> map = this.transportsByHost;
            synchronized (map) {
                transportByHost = this.transportsByHost.get(transport.getBindHost());
                if (transportByHost == null) {
                    transportByHost = new ConcurrentHashSet();
                    this.transportsByHost.put(transport.getBindHost(), (Set<Transport>)transportByHost);
                }
            }
        }
        transportByHost.add((Transport)transport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTransport(String uid) {
        this.assertStateChangesPermitted();
        Transport transport = this.transportsByUID.remove(uid);
        if (transport == null) {
            return;
        }
        transport.stopStatisticsMonitor();
        Set<Transport> transportByHost = this.transportsByHost.get(transport.getBindHost());
        if (transportByHost == null) {
            Map<String, Set<Transport>> map = this.transportsByHost;
            synchronized (map) {
                transportByHost = this.transportsByHost.get(transport.getBindHost());
                if (transportByHost != null) {
                    transportByHost.remove(transport);
                    if (transportByHost.isEmpty()) {
                        this.transportsByHost.remove(transport.getBindHost());
                    }
                }
            }
        } else {
            transportByHost.remove(transport);
        }
    }

    private void assertStateChangesPermitted() {
        this.admin.assertStateChangesPermitted();
    }
}

