/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.transport;

import org.openspaces.admin.transport.TransportStatistics;
import org.openspaces.admin.transport.TransportsDetails;
import org.openspaces.admin.transport.TransportsStatistics;

public class DefaultTransportsStatistics
implements TransportsStatistics {
    private final long timestamp;
    private final TransportStatistics[] stats;
    private volatile TransportsStatistics previousStats;
    private final TransportsDetails details;

    public DefaultTransportsStatistics(TransportStatistics[] stats, TransportsStatistics previousStats, TransportsDetails details, int historySize) {
        this.stats = stats;
        this.timestamp = System.currentTimeMillis();
        this.previousStats = previousStats;
        this.details = details;
        TransportsStatistics lastStats = previousStats;
        if (lastStats != null) {
            for (int i = 0; i < historySize && lastStats.getPrevious() != null; ++i) {
                lastStats = lastStats.getPrevious();
            }
            ((DefaultTransportsStatistics)lastStats).setPreviousStats(null);
        }
    }

    @Override
    public boolean isNA() {
        return this.stats == null || this.stats.length == 0 || this.stats[0].isNA();
    }

    @Override
    public int getSize() {
        return this.stats.length;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public long getPreviousTimestamp() {
        if (this.previousStats == null) {
            return -1L;
        }
        return this.previousStats.getTimestamp();
    }

    @Override
    public TransportsStatistics getPrevious() {
        return this.previousStats;
    }

    public void setPreviousStats(TransportsStatistics previousStats) {
        this.previousStats = previousStats;
    }

    @Override
    public TransportsDetails getDetails() {
        return this.details;
    }

    @Override
    public long getCompletedTaskCount() {
        long total = 0L;
        for (TransportStatistics stat : this.stats) {
            total += stat.getCompletedTaskCount();
        }
        return total;
    }

    @Override
    public double getCompletedTaskPerSecond() {
        double total = 0.0;
        for (TransportStatistics stat : this.stats) {
            double completedTaskPerSecond = stat.getCompletedTaskPerSecond();
            if (completedTaskPerSecond == -1.0) continue;
            total += stat.getCompletedTaskPerSecond();
        }
        return total;
    }

    @Override
    public int getActiveThreadsCount() {
        int total = 0;
        for (TransportStatistics stat : this.stats) {
            if (stat.isNA()) continue;
            total += stat.getActiveThreadsCount();
        }
        return total;
    }

    @Override
    public double getActiveThreadsPerc() {
        double total = 0.0;
        int size = 0;
        for (TransportStatistics stat : this.stats) {
            double perc;
            double d = perc = stat.isNA() ? -1.0 : stat.getActiveThreadsPerc();
            if (perc == -1.0) continue;
            total += perc;
            ++size;
        }
        if (size == 0) {
            return 0.0;
        }
        return total / (double)size;
    }

    @Override
    public int getQueueSize() {
        int total = 0;
        for (TransportStatistics stat : this.stats) {
            if (stat.isNA()) continue;
            total += stat.getQueueSize();
        }
        return total;
    }
}

