/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.transport.events;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.support.GroovyHelper;
import org.openspaces.admin.internal.transport.events.ClosureTransportStatisticsChangedEventListener;
import org.openspaces.admin.internal.transport.events.InternalTransportStatisticsChangedEventManager;
import org.openspaces.admin.transport.events.TransportStatisticsChangedEvent;
import org.openspaces.admin.transport.events.TransportStatisticsChangedEventListener;

public class DefaultTransportStatisticsChangedEventManager
implements InternalTransportStatisticsChangedEventManager {
    private final InternalAdmin admin;
    private final List<TransportStatisticsChangedEventListener> listeners = new CopyOnWriteArrayList<TransportStatisticsChangedEventListener>();

    public DefaultTransportStatisticsChangedEventManager(InternalAdmin admin) {
        this.admin = admin;
    }

    @Override
    public void transportStatisticsChanged(final TransportStatisticsChangedEvent event) {
        for (final TransportStatisticsChangedEventListener listener : this.listeners) {
            this.admin.raiseEvent(listener, new Runnable(){

                @Override
                public void run() {
                    listener.transportStatisticsChanged(event);
                }
            });
        }
    }

    @Override
    public void add(TransportStatisticsChangedEventListener eventListener) {
        this.listeners.add(eventListener);
    }

    @Override
    public void remove(TransportStatisticsChangedEventListener eventListener) {
        this.listeners.remove(eventListener);
    }

    public void plus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.add(new ClosureTransportStatisticsChangedEventListener(eventListener));
        } else {
            this.add((TransportStatisticsChangedEventListener)eventListener);
        }
    }

    public void leftShift(Object eventListener) {
        this.plus(eventListener);
    }

    public void minus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.remove(new ClosureTransportStatisticsChangedEventListener(eventListener));
        } else {
            this.remove((TransportStatisticsChangedEventListener)eventListener);
        }
    }

    public void rightShift(Object eventListener) {
        this.minus(eventListener);
    }
}

