/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.transport.events;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.support.GroovyHelper;
import org.openspaces.admin.internal.transport.events.ClosureTransportsStatisticsChangedEventListener;
import org.openspaces.admin.internal.transport.events.InternalTransportsStatisticsChangedEventManager;
import org.openspaces.admin.transport.events.TransportsStatisticsChangedEvent;
import org.openspaces.admin.transport.events.TransportsStatisticsChangedEventListener;

public class DefaultTransportsStatisticsChangedEventManager
implements InternalTransportsStatisticsChangedEventManager {
    private final InternalAdmin admin;
    private final List<TransportsStatisticsChangedEventListener> listeners = new CopyOnWriteArrayList<TransportsStatisticsChangedEventListener>();

    public DefaultTransportsStatisticsChangedEventManager(InternalAdmin admin) {
        this.admin = admin;
    }

    @Override
    public void transportsStatisticsChanged(final TransportsStatisticsChangedEvent event) {
        for (final TransportsStatisticsChangedEventListener listener : this.listeners) {
            this.admin.raiseEvent(listener, new Runnable(){

                @Override
                public void run() {
                    listener.transportsStatisticsChanged(event);
                }
            });
        }
    }

    @Override
    public void add(TransportsStatisticsChangedEventListener eventListener) {
        this.listeners.add(eventListener);
    }

    @Override
    public void remove(TransportsStatisticsChangedEventListener eventListener) {
        this.listeners.remove(eventListener);
    }

    public void plus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.add(new ClosureTransportsStatisticsChangedEventListener(eventListener));
        } else {
            this.add((TransportsStatisticsChangedEventListener)eventListener);
        }
    }

    public void leftShift(Object eventListener) {
        this.plus(eventListener);
    }

    public void minus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.remove(new ClosureTransportsStatisticsChangedEventListener(eventListener));
        } else {
            this.remove((TransportsStatisticsChangedEventListener)eventListener);
        }
    }

    public void rightShift(Object eventListener) {
        this.minus(eventListener);
    }
}

