/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.utils;

import org.openspaces.admin.internal.pu.InternalProcessingUnit;
import org.openspaces.admin.internal.utils.ServiceTierType;

public class ContextPropertyUtils {
    private static final String CONTEXT_PROPERTY_SERVICE_TIER_TYPE = "com.gs.service.type";
    private static final String CONTEXT_PROPERTY_SERVICE_ICON = "com.gs.service.icon";
    private static final String CONTEXT_PROPERTY_CLOUD_NAME = "com.gs.cloudify.cloud-name";

    public static ServiceTierType getTierType(InternalProcessingUnit processingUnit) {
        String tierType = ContextPropertyUtils.getContextPropertyValue(processingUnit, CONTEXT_PROPERTY_SERVICE_TIER_TYPE);
        if (tierType == null) {
            return ServiceTierType.UNDEFINED;
        }
        return ServiceTierType.valueOf(tierType);
    }

    public static String getIconPath(InternalProcessingUnit processingUnit) {
        return ContextPropertyUtils.getContextPropertyValue(processingUnit, CONTEXT_PROPERTY_SERVICE_ICON);
    }

    public static String getIconName(InternalProcessingUnit processingUnit) {
        if (processingUnit == null) {
            return null;
        }
        String iconPath = ContextPropertyUtils.getIconPath(processingUnit);
        return ContextPropertyUtils.getIconName(iconPath);
    }

    public static String getIconName(String iconPath) {
        if (iconPath == null) {
            return null;
        }
        int startIndex = iconPath.lastIndexOf("/") >= 0 ? iconPath.lastIndexOf("/") + 1 : 0;
        return iconPath.substring(startIndex);
    }

    public static String getCloudName(InternalProcessingUnit processingUnit) {
        String cloudName = ContextPropertyUtils.getContextPropertyValue(processingUnit, CONTEXT_PROPERTY_CLOUD_NAME);
        if (cloudName == null) {
            return "";
        }
        return cloudName;
    }

    private static String getContextPropertyValue(InternalProcessingUnit processingUnit, String contextPropertyKey) {
        String value = processingUnit.getBeanLevelProperties().getContextProperties().getProperty(contextPropertyKey);
        return value;
    }
}

