/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.vm;

import com.gigaspaces.internal.jvm.JVMDetails;
import com.j_spaces.kernel.SizeConcurrentHashMap;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openspaces.admin.esm.ElasticServiceManager;
import org.openspaces.admin.esm.ElasticServiceManagers;
import org.openspaces.admin.gsa.GridServiceAgent;
import org.openspaces.admin.gsa.GridServiceAgents;
import org.openspaces.admin.gsc.GridServiceContainer;
import org.openspaces.admin.gsc.GridServiceContainers;
import org.openspaces.admin.gsm.GridServiceManager;
import org.openspaces.admin.gsm.GridServiceManagers;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.esm.DefaultElasticServiceManagers;
import org.openspaces.admin.internal.esm.InternalElasticServiceManagers;
import org.openspaces.admin.internal.gsa.DefaultGridServiceAgents;
import org.openspaces.admin.internal.gsa.InternalGridServiceAgents;
import org.openspaces.admin.internal.gsc.DefaultGridServiceContainers;
import org.openspaces.admin.internal.gsc.InternalGridServiceContainers;
import org.openspaces.admin.internal.gsm.DefaultGridServiceManagers;
import org.openspaces.admin.internal.gsm.InternalGridServiceManagers;
import org.openspaces.admin.internal.lus.DefaultLookupServices;
import org.openspaces.admin.internal.lus.InternalLookupServices;
import org.openspaces.admin.internal.pu.DefaultProcessingUnitInstances;
import org.openspaces.admin.internal.pu.InternalProcessingUnitInstances;
import org.openspaces.admin.internal.space.DefaultSpaceInstances;
import org.openspaces.admin.internal.space.InternalSpaceInstances;
import org.openspaces.admin.internal.statistics.LastStatisticsHolder;
import org.openspaces.admin.internal.statistics.ScheduledStatisticsHolder;
import org.openspaces.admin.internal.vm.DefaultVirtualMachineDetails;
import org.openspaces.admin.internal.vm.DefaultVirtualMachineStatistics;
import org.openspaces.admin.internal.vm.InternalVirtualMachine;
import org.openspaces.admin.internal.vm.InternalVirtualMachineInfoProvider;
import org.openspaces.admin.internal.vm.InternalVirtualMachines;
import org.openspaces.admin.internal.vm.events.DefaultVirtualMachineStatisticsChangedEventManager;
import org.openspaces.admin.internal.vm.events.InternalVirtualMachineStatisticsChangedEventManager;
import org.openspaces.admin.lus.LookupService;
import org.openspaces.admin.lus.LookupServices;
import org.openspaces.admin.machine.Machine;
import org.openspaces.admin.pu.ProcessingUnitInstance;
import org.openspaces.admin.pu.events.ProcessingUnitInstanceAddedEventManager;
import org.openspaces.admin.pu.events.ProcessingUnitInstanceLifecycleEventListener;
import org.openspaces.admin.pu.events.ProcessingUnitInstanceRemovedEventManager;
import org.openspaces.admin.space.SpaceInstance;
import org.openspaces.admin.space.events.SpaceInstanceAddedEventManager;
import org.openspaces.admin.space.events.SpaceInstanceLifecycleEventListener;
import org.openspaces.admin.space.events.SpaceInstanceRemovedEventManager;
import org.openspaces.admin.vm.VirtualMachineDetails;
import org.openspaces.admin.vm.VirtualMachineStatistics;
import org.openspaces.admin.vm.events.VirtualMachineStatisticsChangedEvent;
import org.openspaces.admin.vm.events.VirtualMachineStatisticsChangedEventManager;

public class DefaultVirtualMachine
implements InternalVirtualMachine {
    private final InternalAdmin admin;
    private final InternalVirtualMachines virtualMachines;
    private final String uid;
    private final VirtualMachineDetails details;
    private final Map<String, InternalVirtualMachineInfoProvider> virtualMachineInfoProvidersByUID = new SizeConcurrentHashMap();
    private volatile Machine machine;
    private final InternalLookupServices lookupServices;
    private final InternalGridServiceAgents gridServiceAgents;
    private final InternalGridServiceManagers gridServiceManagers;
    private final InternalElasticServiceManagers elasticServiceManagers;
    private final InternalGridServiceContainers gridServiceContainers;
    private final InternalProcessingUnitInstances processingUnitInstances;
    private final InternalSpaceInstances spaceInstances;
    private final LastStatisticsHolder<VirtualMachineStatistics> lastStatisticsHolder = new LastStatisticsHolder<DefaultVirtualMachineStatistics>(new DefaultVirtualMachineStatistics());
    private final ScheduledStatisticsHolder scheduledStatisticsHolder = new ScheduledStatisticsHolder();
    private final InternalVirtualMachineStatisticsChangedEventManager statisticsChangedEventManager;

    public DefaultVirtualMachine(InternalVirtualMachines virtualMachines, JVMDetails details, String jmxUrl) {
        this.virtualMachines = virtualMachines;
        this.admin = (InternalAdmin)virtualMachines.getAdmin();
        this.details = new DefaultVirtualMachineDetails(details, jmxUrl);
        this.uid = details.getUid();
        this.lookupServices = new DefaultLookupServices(this.admin);
        this.gridServiceAgents = new DefaultGridServiceAgents(this.admin);
        this.gridServiceManagers = new DefaultGridServiceManagers(this.admin);
        this.elasticServiceManagers = new DefaultElasticServiceManagers(this.admin);
        this.gridServiceContainers = new DefaultGridServiceContainers(this.admin);
        this.processingUnitInstances = new DefaultProcessingUnitInstances(this.admin);
        this.spaceInstances = new DefaultSpaceInstances(this.admin);
        this.statisticsChangedEventManager = new DefaultVirtualMachineStatisticsChangedEventManager(this.admin, this);
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public void addVirtualMachineInfoProvider(InternalVirtualMachineInfoProvider virtualMachineInfoProvider) {
        this.assertStateChangesPermitted();
        this.virtualMachineInfoProvidersByUID.put(virtualMachineInfoProvider.getUid(), virtualMachineInfoProvider);
    }

    @Override
    public void removeVirtualMachineInfoProvider(InternalVirtualMachineInfoProvider virtualMachineInfoProvider) {
        this.assertStateChangesPermitted();
        this.virtualMachineInfoProvidersByUID.remove(virtualMachineInfoProvider.getUid());
    }

    @Override
    public boolean hasVirtualMachineInfoProviders() {
        return !this.virtualMachineInfoProvidersByUID.isEmpty();
    }

    @Override
    public VirtualMachineStatisticsChangedEventManager getVirtualMachineStatisticsChanged() {
        return this.statisticsChangedEventManager;
    }

    @Override
    public VirtualMachineDetails getDetails() {
        return this.details;
    }

    @Override
    public Machine getMachine() {
        return this.machine;
    }

    @Override
    public void setMachine(Machine machine) {
        this.assertStateChangesPermitted();
        this.machine = machine;
    }

    @Override
    public LookupService getLookupService() {
        Iterator it = this.lookupServices.iterator();
        if (it.hasNext()) {
            return (LookupService)it.next();
        }
        return null;
    }

    @Override
    public LookupServices getLookupServices() {
        return this.lookupServices;
    }

    @Override
    public GridServiceAgents getGridServiceAgents() {
        return this.gridServiceAgents;
    }

    @Override
    public GridServiceAgent getGridServiceAgent() {
        Iterator it = this.gridServiceAgents.iterator();
        if (it.hasNext()) {
            return (GridServiceAgent)it.next();
        }
        return null;
    }

    @Override
    public GridServiceManager getGridServiceManager() {
        Iterator it = this.gridServiceManagers.iterator();
        if (it.hasNext()) {
            return (GridServiceManager)it.next();
        }
        return null;
    }

    @Override
    public ElasticServiceManager getElasticServiceManager() {
        Iterator it = this.elasticServiceManagers.iterator();
        if (it.hasNext()) {
            return (ElasticServiceManager)it.next();
        }
        return null;
    }

    @Override
    public GridServiceContainer getGridServiceContainer() {
        Iterator it = this.gridServiceContainers.iterator();
        if (it.hasNext()) {
            return (GridServiceContainer)it.next();
        }
        return null;
    }

    @Override
    public GridServiceManagers getGridServiceManagers() {
        return this.gridServiceManagers;
    }

    @Override
    public ElasticServiceManagers getElasticServiceManagers() {
        return this.elasticServiceManagers;
    }

    @Override
    public GridServiceContainers getGridServiceContainers() {
        return this.gridServiceContainers;
    }

    @Override
    public ProcessingUnitInstance[] getProcessingUnitInstances() {
        return this.processingUnitInstances.getInstances();
    }

    @Override
    public ProcessingUnitInstanceAddedEventManager getProcessingUnitInstanceAdded() {
        return this.processingUnitInstances.getProcessingUnitInstanceAdded();
    }

    @Override
    public ProcessingUnitInstanceRemovedEventManager getProcessingUnitInstanceRemoved() {
        return this.processingUnitInstances.getProcessingUnitInstanceRemoved();
    }

    @Override
    public void addProcessingUnitInstanceLifecycleEventListener(ProcessingUnitInstanceLifecycleEventListener eventListener) {
        this.processingUnitInstances.addProcessingUnitInstanceLifecycleEventListener(eventListener);
    }

    @Override
    public void removeProcessingUnitInstanceLifecycleEventListener(ProcessingUnitInstanceLifecycleEventListener eventListener) {
        this.processingUnitInstances.removeProcessingUnitInstanceLifecycleEventListener(eventListener);
    }

    @Override
    public SpaceInstance[] getSpaceInstances() {
        return this.spaceInstances.getSpaceInstances();
    }

    @Override
    public SpaceInstanceAddedEventManager getSpaceInstanceAdded() {
        return this.spaceInstances.getSpaceInstanceAdded();
    }

    @Override
    public SpaceInstanceRemovedEventManager getSpaceInstanceRemoved() {
        return this.spaceInstances.getSpaceInstanceRemoved();
    }

    @Override
    public void addLifecycleListener(SpaceInstanceLifecycleEventListener eventListener) {
        this.spaceInstances.addLifecycleListener(eventListener);
    }

    @Override
    public void removeLifecycleListener(SpaceInstanceLifecycleEventListener eventListener) {
        this.spaceInstances.removeLifecycleListener(eventListener);
    }

    @Override
    public void addProcessingUnitInstance(ProcessingUnitInstance processingUnitInstance) {
        this.processingUnitInstances.addInstance(processingUnitInstance);
    }

    @Override
    public void removeProcessingUnitInstance(String uid) {
        this.processingUnitInstances.removeInstance(uid);
    }

    @Override
    public void addSpaceInstance(SpaceInstance spaceInstance) {
        this.spaceInstances.addSpaceInstance(spaceInstance);
    }

    @Override
    public void removeSpaceInstance(String uid) {
        this.spaceInstances.removeSpaceInstance(uid);
    }

    @Override
    public void runGc() {
        Collection<InternalVirtualMachineInfoProvider> virtualMachineInfoProviders = this.virtualMachineInfoProvidersByUID.values();
        for (InternalVirtualMachineInfoProvider provider : virtualMachineInfoProviders) {
            try {
                provider.runGc();
                break;
            }
            catch (RemoteException remoteException) {
            }
        }
    }

    @Override
    public VirtualMachineStatistics getStatistics() {
        if (this.lastStatisticsHolder.validCache(this.scheduledStatisticsHolder.getStatisticsInterval())) {
            return this.lastStatisticsHolder.getLastStatistics();
        }
        boolean acquired = this.lastStatisticsHolder.acquireLastStatisticsLock();
        if (acquired) {
            try {
                this.lastStatisticsHolder.updateLastStatistics(this.doGetStatistics());
            }
            finally {
                this.lastStatisticsHolder.releaseLastStatisticsLock();
            }
        } else if (this.lastStatisticsHolder.getLastStatistics().isNA()) {
            this.lastStatisticsHolder.waitForLastStatistics();
        }
        return this.lastStatisticsHolder.getLastStatistics();
    }

    private VirtualMachineStatistics doGetStatistics() {
        Collection<InternalVirtualMachineInfoProvider> virtualMachineInfoProviders = this.virtualMachineInfoProvidersByUID.values();
        for (InternalVirtualMachineInfoProvider provider : virtualMachineInfoProviders) {
            try {
                if (this.getMachine() == null) continue;
                VirtualMachineStatistics previousStatistics = this.lastStatisticsHolder.getLastStatistics();
                return new DefaultVirtualMachineStatistics(provider.getJVMStatistics(), previousStatistics, this.getDetails(), this.scheduledStatisticsHolder.getStatisticsHistorySize(), this.getMachine().getOperatingSystem().getTimeDelta());
            }
            catch (RemoteException remoteException) {
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStatisticsInterval(long interval, TimeUnit timeUnit) {
        ScheduledStatisticsHolder scheduledStatisticsHolder = this.scheduledStatisticsHolder;
        synchronized (scheduledStatisticsHolder) {
            this.scheduledStatisticsHolder.updateStatisticsInterval(interval, timeUnit);
            if (this.scheduledStatisticsHolder.isMonitoring()) {
                this.stopStatisticsMonitor();
                this.startStatisticsMonitor();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStatisticsHistorySize(int historySize) {
        ScheduledStatisticsHolder scheduledStatisticsHolder = this.scheduledStatisticsHolder;
        synchronized (scheduledStatisticsHolder) {
            this.scheduledStatisticsHolder.updateStatisticsHistorySize(historySize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startStatisticsMonitor() {
        ScheduledStatisticsHolder scheduledStatisticsHolder = this.scheduledStatisticsHolder;
        synchronized (scheduledStatisticsHolder) {
            if (this.scheduledStatisticsHolder.getAndIncrementRefCount() > 0) {
                return;
            }
            if (this.scheduledStatisticsHolder.isMonitoring()) {
                this.scheduledStatisticsHolder.cancelMonitor(false);
            }
            final DefaultVirtualMachine virtualMachine = this;
            this.scheduledStatisticsHolder.updateMonitor(this.admin.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    VirtualMachineStatistics stats = virtualMachine.getStatistics();
                    VirtualMachineStatisticsChangedEvent event = new VirtualMachineStatisticsChangedEvent(virtualMachine, stats);
                    DefaultVirtualMachine.this.statisticsChangedEventManager.virtualMachineStatisticsChanged(event);
                    ((InternalVirtualMachineStatisticsChangedEventManager)DefaultVirtualMachine.this.virtualMachines.getVirtualMachineStatisticsChanged()).virtualMachineStatisticsChanged(event);
                }
            }, 0L, this.scheduledStatisticsHolder.getStatisticsInterval(), TimeUnit.MILLISECONDS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopStatisticsMonitor() {
        ScheduledStatisticsHolder scheduledStatisticsHolder = this.scheduledStatisticsHolder;
        synchronized (scheduledStatisticsHolder) {
            if (this.scheduledStatisticsHolder.decrementAndGetRefCount() > 0) {
                return;
            }
            if (this.scheduledStatisticsHolder.isMonitoring()) {
                this.scheduledStatisticsHolder.cancelMonitor(false);
                this.scheduledStatisticsHolder.updateMonitor(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isMonitoring() {
        ScheduledStatisticsHolder scheduledStatisticsHolder = this.scheduledStatisticsHolder;
        synchronized (scheduledStatisticsHolder) {
            return this.scheduledStatisticsHolder.isMonitoring();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultVirtualMachine that = (DefaultVirtualMachine)o;
        return this.uid.equals(that.uid);
    }

    public int hashCode() {
        return this.uid.hashCode();
    }

    private void assertStateChangesPermitted() {
        this.admin.assertStateChangesPermitted();
    }
}

