/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.vm;

import com.gigaspaces.internal.jvm.JVMDetails;
import java.util.Map;
import org.openspaces.admin.support.StatisticsUtils;
import org.openspaces.admin.vm.VirtualMachineDetails;

public class DefaultVirtualMachineDetails
implements VirtualMachineDetails {
    private final JVMDetails details;
    private final String jmxUrl;

    public DefaultVirtualMachineDetails() {
        this(new JVMDetails(), "");
    }

    public DefaultVirtualMachineDetails(JVMDetails details, String jmxUrl) {
        this.details = details;
        this.jmxUrl = jmxUrl;
    }

    @Override
    public String getJmxUrl() {
        return this.jmxUrl;
    }

    @Override
    public boolean isNA() {
        return this.details.isNA();
    }

    @Override
    public String getUid() {
        return this.details.getUid();
    }

    @Override
    public String getVmName() {
        return this.details.getVmName();
    }

    @Override
    public String getVmVersion() {
        return this.details.getVmVersion();
    }

    @Override
    public String getVmVendor() {
        return this.details.getVmVendor();
    }

    @Override
    public long getStartTime() {
        return this.details.getStartTime();
    }

    @Override
    public long getPid() {
        return this.details.getPid();
    }

    @Override
    public String getBootClassPath() {
        return this.details.getBootClassPath();
    }

    @Override
    public String getClassPath() {
        return this.details.getClassPath();
    }

    @Override
    public String[] getInputArguments() {
        return this.details.getInputArguments();
    }

    @Override
    public Map<String, String> getSystemProperties() {
        return this.details.getSystemProperties();
    }

    @Override
    public Map<String, String> getEnvironmentVariables() {
        return this.details.getEnvironmentVariables();
    }

    @Override
    public long getMemoryHeapInitInBytes() {
        return this.details.getMemoryHeapInit();
    }

    @Override
    public double getMemoryHeapInitInMB() {
        return StatisticsUtils.convertToMB(this.getMemoryHeapInitInBytes());
    }

    @Override
    public double getMemoryHeapInitInGB() {
        return StatisticsUtils.convertToGB(this.getMemoryHeapInitInBytes());
    }

    @Override
    public long getMemoryHeapMaxInBytes() {
        return this.details.getMemoryHeapMax();
    }

    @Override
    public double getMemoryHeapMaxInMB() {
        return StatisticsUtils.convertToMB(this.getMemoryHeapMaxInBytes());
    }

    @Override
    public double getMemoryHeapMaxInGB() {
        return StatisticsUtils.convertToGB(this.getMemoryHeapMaxInBytes());
    }

    @Override
    public long getMemoryNonHeapInitInBytes() {
        return this.details.getMemoryNonHeapInit();
    }

    @Override
    public double getMemoryNonHeapInitInMB() {
        return StatisticsUtils.convertToMB(this.getMemoryNonHeapInitInBytes());
    }

    @Override
    public double getMemoryNonHeapInitInGB() {
        return StatisticsUtils.convertToGB(this.getMemoryNonHeapInitInBytes());
    }

    @Override
    public long getMemoryNonHeapMaxInBytes() {
        return this.details.getMemoryNonHeapMax();
    }

    @Override
    public double getMemoryNonHeapMaxInMB() {
        return StatisticsUtils.convertToMB(this.getMemoryNonHeapMaxInBytes());
    }

    @Override
    public double getMemoryNonHeapMaxInGB() {
        return StatisticsUtils.convertToGB(this.getMemoryNonHeapMaxInBytes());
    }
}

