/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.vm;

import com.gigaspaces.internal.jvm.JVMStatistics;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.openspaces.admin.support.StatisticsUtils;
import org.openspaces.admin.vm.VirtualMachineDetails;
import org.openspaces.admin.vm.VirtualMachineStatistics;

public class DefaultVirtualMachineStatistics
implements VirtualMachineStatistics {
    private static final JVMStatistics NA_STATS = new JVMStatistics();
    private final long timeDelta;
    private final JVMStatistics stats;
    private final VirtualMachineDetails details;
    private volatile VirtualMachineStatistics previousStats;
    private final double cpuPerc;
    private final double gcCollectionPerc;
    private final long previousTimeStamp;

    public DefaultVirtualMachineStatistics() {
        this(NA_STATS, null, null, 0, -1L);
    }

    public DefaultVirtualMachineStatistics(JVMStatistics stats, VirtualMachineStatistics previousStats, VirtualMachineDetails details, int historySize, long timeDelta) {
        this.stats = stats;
        this.previousStats = previousStats;
        this.details = details;
        this.timeDelta = timeDelta;
        if (previousStats == null) {
            this.cpuPerc = -1.0;
            this.gcCollectionPerc = -1.0;
            this.previousTimeStamp = -1L;
        } else {
            this.cpuPerc = stats.computeCpuPerc(((DefaultVirtualMachineStatistics)previousStats).stats);
            this.previousTimeStamp = previousStats.getTimestamp();
            this.gcCollectionPerc = StatisticsUtils.computePercByTime(this.getGcCollectionTime(), previousStats.getGcCollectionTime(), this.getTimestamp(), this.previousTimeStamp);
        }
        VirtualMachineStatistics lastStats = previousStats;
        if (lastStats != null) {
            for (int i = 0; i < historySize && lastStats.getPrevious() != null; ++i) {
                lastStats = lastStats.getPrevious();
            }
            ((DefaultVirtualMachineStatistics)lastStats).setPreviousStats(null);
        }
    }

    @Override
    public boolean isNA() {
        return this.stats.isNA();
    }

    @Override
    public long getTimestamp() {
        return this.stats.getTimestamp();
    }

    @Override
    public long getAdminTimestamp() {
        if (this.stats.getTimestamp() != -1L && this.timeDelta != Integer.MIN_VALUE) {
            return this.stats.getTimestamp() + this.timeDelta;
        }
        return -1L;
    }

    @Override
    public VirtualMachineDetails getDetails() {
        return this.details;
    }

    @Override
    public List<VirtualMachineStatistics> getTimeline() {
        ArrayList<VirtualMachineStatistics> timeline = new ArrayList<VirtualMachineStatistics>();
        timeline.add(this);
        for (VirtualMachineStatistics current = this.getPrevious(); current != null && !current.isNA(); current = current.getPrevious()) {
            timeline.add(current);
        }
        return timeline;
    }

    @Override
    public VirtualMachineStatistics getPrevious() {
        return this.previousStats;
    }

    public void setPreviousStats(VirtualMachineStatistics previousStats) {
        this.previousStats = previousStats;
    }

    @Override
    public long getPreviousTimestamp() {
        return this.previousTimeStamp;
    }

    @Override
    public long getUptime() {
        return this.stats.getUptime();
    }

    @Override
    public long getMemoryHeapCommittedInBytes() {
        return this.stats.getMemoryHeapCommitted();
    }

    @Override
    public double getMemoryHeapCommittedInMB() {
        return StatisticsUtils.convertToMB(this.getMemoryHeapCommittedInBytes());
    }

    @Override
    public double getMemoryHeapCommittedInGB() {
        return StatisticsUtils.convertToGB(this.getMemoryHeapCommittedInBytes());
    }

    @Override
    public long getMemoryHeapUsedInBytes() {
        return this.stats.getMemoryHeapUsed();
    }

    @Override
    public double getMemoryHeapUsedInMB() {
        return StatisticsUtils.convertToMB(this.getMemoryHeapUsedInBytes());
    }

    @Override
    public double getMemoryHeapUsedInGB() {
        return StatisticsUtils.convertToGB(this.getMemoryHeapUsedInBytes());
    }

    @Override
    public double getMemoryHeapUsedPerc() {
        if (this.isNA()) {
            return -1.0;
        }
        return StatisticsUtils.computePerc(this.getMemoryHeapUsedInBytes(), this.getDetails().getMemoryHeapMaxInBytes());
    }

    @Override
    public double getMemoryHeapCommittedUsedPerc() {
        return StatisticsUtils.computePerc(this.getMemoryHeapUsedInBytes(), this.getMemoryHeapCommittedInBytes());
    }

    @Override
    public long getMemoryNonHeapCommittedInBytes() {
        return this.stats.getMemoryNonHeapCommitted();
    }

    @Override
    public double getMemoryNonHeapCommittedInMB() {
        return StatisticsUtils.convertToMB(this.getMemoryNonHeapCommittedInBytes());
    }

    @Override
    public double getMemoryNonHeapCommittedInGB() {
        return StatisticsUtils.convertToGB(this.getMemoryNonHeapCommittedInBytes());
    }

    @Override
    public long getMemoryNonHeapUsedInBytes() {
        return this.stats.getMemoryNonHeapUsed();
    }

    @Override
    public double getMemoryNonHeapUsedInMB() {
        return StatisticsUtils.convertToMB(this.getMemoryNonHeapUsedInBytes());
    }

    @Override
    public double getMemoryNonHeapUsedInGB() {
        return StatisticsUtils.convertToGB(this.getMemoryNonHeapUsedInBytes());
    }

    @Override
    public double getMemoryNonHeapUsedPerc() {
        if (this.isNA()) {
            return -1.0;
        }
        return StatisticsUtils.computePerc(this.getMemoryNonHeapUsedInBytes(), this.getDetails().getMemoryNonHeapMaxInBytes());
    }

    @Override
    public double getMemoryNonHeapCommittedUsedPerc() {
        return StatisticsUtils.computePerc(this.getMemoryNonHeapUsedInBytes(), this.getMemoryNonHeapCommittedInBytes());
    }

    @Override
    public int getThreadCount() {
        return this.stats.getThreadCount();
    }

    @Override
    public int getPeakThreadCount() {
        return this.stats.getPeakThreadCount();
    }

    @Override
    public long getGcCollectionCount() {
        return this.stats.getGcCollectionCount();
    }

    @Override
    public long getGcCollectionTime() {
        return this.stats.getGcCollectionTime();
    }

    @Override
    public double getGcCollectionPerc() {
        return this.gcCollectionPerc;
    }

    @Override
    public double getCpuPerc() {
        return this.cpuPerc;
    }

    @Override
    public double getCpuPercAverage(long requestedTotalTime, TimeUnit timeUnit) {
        double result;
        if (requestedTotalTime <= 0L) {
            throw new IllegalArgumentException("Total time has to be positive");
        }
        long requestedTotalTimeMillis = TimeUnit.MILLISECONDS.convert(requestedTotalTime, timeUnit);
        long endTimeStamp = this.stats.getTimestamp();
        DefaultVirtualMachineStatistics start = (DefaultVirtualMachineStatistics)this.getPrevious();
        if (start == null) {
            return -1.0;
        }
        DefaultVirtualMachineStatistics previousStart = null;
        long duration = endTimeStamp - start.getTimestamp();
        long previousDuration = 0L;
        while (duration < requestedTotalTimeMillis) {
            previousStart = start;
            previousDuration = duration;
            start = (DefaultVirtualMachineStatistics)previousStart.getPrevious();
            if (start == null) {
                return -1.0;
            }
            duration = endTimeStamp - start.getTimestamp();
        }
        if (duration == previousDuration) {
            throw new IllegalStateException("This can never happen");
        }
        if (previousDuration == 0L) {
            result = this.stats.computeCpuPerc(start.stats);
        } else {
            long timeSlot = duration - previousDuration;
            double rightWeight = (double)(requestedTotalTimeMillis - previousDuration) / (double)timeSlot;
            double leftWeight = (double)(duration - requestedTotalTimeMillis) / (double)timeSlot;
            result = rightWeight * this.stats.computeCpuPerc(start.stats) + leftWeight * this.stats.computeCpuPerc(previousStart.stats);
        }
        return result;
    }

    @Override
    public String getCpuPercFormatted() {
        return StatisticsUtils.formatPerc(this.getCpuPerc());
    }
}

