/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.vm;

import com.j_spaces.kernel.SizeConcurrentHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openspaces.admin.Admin;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.statistics.LastStatisticsHolder;
import org.openspaces.admin.internal.statistics.ScheduledStatisticsHolder;
import org.openspaces.admin.internal.vm.DefaultVirtualMachinesDetails;
import org.openspaces.admin.internal.vm.DefaultVirtualMachinesStatistics;
import org.openspaces.admin.internal.vm.InternalVirtualMachine;
import org.openspaces.admin.internal.vm.InternalVirtualMachines;
import org.openspaces.admin.internal.vm.events.DefaultVirtualMachineAddedEventManager;
import org.openspaces.admin.internal.vm.events.DefaultVirtualMachineRemovedEventManager;
import org.openspaces.admin.internal.vm.events.DefaultVirtualMachineStatisticsChangedEventManager;
import org.openspaces.admin.internal.vm.events.DefaultVirtualMachinesStatisticsChangedEventManager;
import org.openspaces.admin.internal.vm.events.InternalVirtualMachineAddedEventManager;
import org.openspaces.admin.internal.vm.events.InternalVirtualMachineRemovedEventManager;
import org.openspaces.admin.internal.vm.events.InternalVirtualMachineStatisticsChangedEventManager;
import org.openspaces.admin.internal.vm.events.InternalVirtualMachinesStatisticsChangedEventManager;
import org.openspaces.admin.vm.VirtualMachine;
import org.openspaces.admin.vm.VirtualMachineDetails;
import org.openspaces.admin.vm.VirtualMachineStatistics;
import org.openspaces.admin.vm.VirtualMachinesDetails;
import org.openspaces.admin.vm.VirtualMachinesStatistics;
import org.openspaces.admin.vm.events.VirtualMachineAddedEventManager;
import org.openspaces.admin.vm.events.VirtualMachineLifecycleEventListener;
import org.openspaces.admin.vm.events.VirtualMachineRemovedEventManager;
import org.openspaces.admin.vm.events.VirtualMachineStatisticsChangedEventManager;
import org.openspaces.admin.vm.events.VirtualMachinesStatisticsChangedEvent;
import org.openspaces.admin.vm.events.VirtualMachinesStatisticsChangedEventManager;

public class DefaultVirtualMachines
implements InternalVirtualMachines {
    private final InternalAdmin admin;
    private final Map<String, VirtualMachine> virtualMachinesByUID = new SizeConcurrentHashMap();
    private final InternalVirtualMachineAddedEventManager virtualMachineAddedEventManager;
    private final InternalVirtualMachineRemovedEventManager virtualMachineRemovedEventManager;
    private final InternalVirtualMachineStatisticsChangedEventManager virtualMachineStatisticsChangedEventManager;
    private final InternalVirtualMachinesStatisticsChangedEventManager virtualMachinesStatisticsChangedEventManager;
    private final LastStatisticsHolder<VirtualMachinesStatistics> lastStatisticsHolder = new LastStatisticsHolder();
    private final ScheduledStatisticsHolder scheduledStatisticsHolder = new ScheduledStatisticsHolder();

    public DefaultVirtualMachines(InternalAdmin admin) {
        this.admin = admin;
        this.virtualMachineAddedEventManager = new DefaultVirtualMachineAddedEventManager(this);
        this.virtualMachineRemovedEventManager = new DefaultVirtualMachineRemovedEventManager(this);
        this.virtualMachineStatisticsChangedEventManager = new DefaultVirtualMachineStatisticsChangedEventManager(admin, this);
        this.virtualMachinesStatisticsChangedEventManager = new DefaultVirtualMachinesStatisticsChangedEventManager(admin, this);
    }

    @Override
    public Admin getAdmin() {
        return this.admin;
    }

    @Override
    public VirtualMachineAddedEventManager getVirtualMachineAdded() {
        return this.virtualMachineAddedEventManager;
    }

    @Override
    public VirtualMachineRemovedEventManager getVirtualMachineRemoved() {
        return this.virtualMachineRemovedEventManager;
    }

    @Override
    public VirtualMachineStatisticsChangedEventManager getVirtualMachineStatisticsChanged() {
        return this.virtualMachineStatisticsChangedEventManager;
    }

    @Override
    public VirtualMachinesStatisticsChangedEventManager getStatisticsChanged() {
        return this.virtualMachinesStatisticsChangedEventManager;
    }

    @Override
    public VirtualMachine[] getVirtualMachines() {
        return this.virtualMachinesByUID.values().toArray(new VirtualMachine[0]);
    }

    @Override
    public Iterator<VirtualMachine> iterator() {
        return Collections.unmodifiableCollection(this.virtualMachinesByUID.values()).iterator();
    }

    @Override
    public int getSize() {
        return this.virtualMachinesByUID.size();
    }

    @Override
    public boolean isEmpty() {
        return this.virtualMachinesByUID.size() == 0;
    }

    @Override
    public VirtualMachinesStatistics getStatistics() {
        if (this.lastStatisticsHolder.validCache(this.scheduledStatisticsHolder.getStatisticsInterval())) {
            return this.lastStatisticsHolder.getLastStatistics();
        }
        boolean acquired = this.lastStatisticsHolder.acquireLastStatisticsLock();
        if (acquired) {
            try {
                this.lastStatisticsHolder.updateLastStatistics(this.doGetStatistics());
            }
            finally {
                this.lastStatisticsHolder.releaseLastStatisticsLock();
            }
        } else if (this.lastStatisticsHolder.getLastStatistics() == null) {
            this.lastStatisticsHolder.waitForLastStatistics();
        }
        return this.lastStatisticsHolder.getLastStatistics();
    }

    private VirtualMachinesStatistics doGetStatistics() {
        ArrayList<VirtualMachineDetails> details = new ArrayList<VirtualMachineDetails>();
        ArrayList<VirtualMachineStatistics> stats = new ArrayList<VirtualMachineStatistics>();
        for (VirtualMachine virtualMachine : this.virtualMachinesByUID.values()) {
            stats.add(virtualMachine.getStatistics());
            details.add(virtualMachine.getDetails());
        }
        VirtualMachinesStatistics previousStats = this.lastStatisticsHolder.getLastStatistics();
        return new DefaultVirtualMachinesStatistics(stats.toArray(new VirtualMachineStatistics[stats.size()]), new DefaultVirtualMachinesDetails(details.toArray(new VirtualMachineDetails[details.size()])), previousStats, this.scheduledStatisticsHolder.getStatisticsHistorySize());
    }

    @Override
    public VirtualMachinesDetails getDetails() {
        ArrayList<VirtualMachineDetails> details = new ArrayList<VirtualMachineDetails>();
        for (VirtualMachine virtualMachine : this.virtualMachinesByUID.values()) {
            details.add(virtualMachine.getDetails());
        }
        return new DefaultVirtualMachinesDetails(details.toArray(new VirtualMachineDetails[details.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStatisticsInterval(long interval, TimeUnit timeUnit) {
        ScheduledStatisticsHolder scheduledStatisticsHolder = this.scheduledStatisticsHolder;
        synchronized (scheduledStatisticsHolder) {
            this.scheduledStatisticsHolder.updateStatisticsInterval(interval, timeUnit);
            if (this.scheduledStatisticsHolder.isMonitoring()) {
                this.rescheduleStatisticsMonitor();
            }
            for (VirtualMachine virualMachine : this.virtualMachinesByUID.values()) {
                virualMachine.setStatisticsInterval(interval, timeUnit);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStatisticsHistorySize(int historySize) {
        ScheduledStatisticsHolder scheduledStatisticsHolder = this.scheduledStatisticsHolder;
        synchronized (scheduledStatisticsHolder) {
            this.scheduledStatisticsHolder.updateStatisticsHistorySize(historySize);
            for (VirtualMachine virualMachine : this.virtualMachinesByUID.values()) {
                virualMachine.setStatisticsHistorySize(historySize);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startStatisticsMonitor() {
        ScheduledStatisticsHolder scheduledStatisticsHolder = this.scheduledStatisticsHolder;
        synchronized (scheduledStatisticsHolder) {
            this.rescheduleStatisticsMonitor();
            for (VirtualMachine virtualMachine : this.virtualMachinesByUID.values()) {
                virtualMachine.startStatisticsMonitor();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopStatisticsMonitor() {
        ScheduledStatisticsHolder scheduledStatisticsHolder = this.scheduledStatisticsHolder;
        synchronized (scheduledStatisticsHolder) {
            this.stopScheduledStatisticsMonitor();
            for (VirtualMachine virtualMachine : this.virtualMachinesByUID.values()) {
                virtualMachine.stopStatisticsMonitor();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopScheduledStatisticsMonitor() {
        ScheduledStatisticsHolder scheduledStatisticsHolder = this.scheduledStatisticsHolder;
        synchronized (scheduledStatisticsHolder) {
            if (this.scheduledStatisticsHolder.decrementAndGetRefCount() > 0) {
                return;
            }
            if (this.scheduledStatisticsHolder.isMonitoring()) {
                this.scheduledStatisticsHolder.cancelMonitor(false);
                this.scheduledStatisticsHolder.updateMonitor(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isMonitoring() {
        ScheduledStatisticsHolder scheduledStatisticsHolder = this.scheduledStatisticsHolder;
        synchronized (scheduledStatisticsHolder) {
            return this.scheduledStatisticsHolder.isMonitoring();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rescheduleStatisticsMonitor() {
        ScheduledStatisticsHolder scheduledStatisticsHolder = this.scheduledStatisticsHolder;
        synchronized (scheduledStatisticsHolder) {
            if (this.scheduledStatisticsHolder.getAndIncrementRefCount() > 0) {
                return;
            }
            if (this.scheduledStatisticsHolder.isMonitoring()) {
                this.scheduledStatisticsHolder.cancelMonitor(false);
            }
            this.scheduledStatisticsHolder.updateMonitor(this.admin.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    VirtualMachinesStatistics stats = DefaultVirtualMachines.this.getStatistics();
                    VirtualMachinesStatisticsChangedEvent event = new VirtualMachinesStatisticsChangedEvent(DefaultVirtualMachines.this, stats);
                    DefaultVirtualMachines.this.virtualMachinesStatisticsChangedEventManager.virtualMachinesStatisticsChanged(event);
                }
            }, 0L, this.scheduledStatisticsHolder.getStatisticsInterval(), TimeUnit.MILLISECONDS));
        }
    }

    @Override
    public void addLifecycleListener(VirtualMachineLifecycleEventListener eventListener) {
        this.getVirtualMachineAdded().add(eventListener);
        this.getVirtualMachineRemoved().add(eventListener);
    }

    @Override
    public void removeLifecycleListener(VirtualMachineLifecycleEventListener eventListener) {
        this.getVirtualMachineAdded().remove(eventListener);
        this.getVirtualMachineRemoved().remove(eventListener);
    }

    @Override
    public VirtualMachine getVirtualMachineByUID(String uid) {
        return this.virtualMachinesByUID.get(uid);
    }

    @Override
    public Map<String, VirtualMachine> getUids() {
        return Collections.unmodifiableMap(this.virtualMachinesByUID);
    }

    @Override
    public void addVirtualMachine(final VirtualMachine virtualMachine) {
        this.assertStateChangesPermmited();
        VirtualMachine existingVM = this.virtualMachinesByUID.put(virtualMachine.getUid(), virtualMachine);
        if (existingVM == null) {
            if (this.isMonitoring()) {
                this.admin.raiseEvent(this, new Runnable(){

                    @Override
                    public void run() {
                        virtualMachine.setStatisticsInterval(DefaultVirtualMachines.this.scheduledStatisticsHolder.getStatisticsInterval(), TimeUnit.MILLISECONDS);
                        virtualMachine.setStatisticsHistorySize(DefaultVirtualMachines.this.scheduledStatisticsHolder.getStatisticsHistorySize());
                        virtualMachine.startStatisticsMonitor();
                    }
                });
            }
            this.virtualMachineAddedEventManager.virtualMachineAdded(virtualMachine);
        }
    }

    @Override
    public InternalVirtualMachine removeVirtualMachine(String uid) {
        this.assertStateChangesPermmited();
        InternalVirtualMachine existingVM = (InternalVirtualMachine)this.virtualMachinesByUID.remove(uid);
        if (existingVM != null) {
            existingVM.stopStatisticsMonitor();
            this.virtualMachineRemovedEventManager.virtualMachineRemoved(existingVM);
        }
        return existingVM;
    }

    private void assertStateChangesPermmited() {
        this.admin.assertStateChangesPermitted();
    }
}

