/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.vm;

import java.util.HashSet;
import org.openspaces.admin.support.StatisticsUtils;
import org.openspaces.admin.vm.VirtualMachineDetails;
import org.openspaces.admin.vm.VirtualMachinesDetails;

public class DefaultVirtualMachinesDetails
implements VirtualMachinesDetails {
    private final VirtualMachineDetails[] details;

    public DefaultVirtualMachinesDetails(VirtualMachineDetails[] details) {
        this.details = details;
    }

    @Override
    public int getSize() {
        return this.details.length;
    }

    @Override
    public String[] getVmName() {
        HashSet<String> values = new HashSet<String>();
        for (VirtualMachineDetails detail : this.details) {
            values.add(detail.getVmName());
        }
        return values.toArray(new String[values.size()]);
    }

    @Override
    public String[] getVmVersion() {
        HashSet<String> values = new HashSet<String>();
        for (VirtualMachineDetails detail : this.details) {
            values.add(detail.getVmVersion());
        }
        return values.toArray(new String[values.size()]);
    }

    @Override
    public String[] getVmVendor() {
        HashSet<String> values = new HashSet<String>();
        for (VirtualMachineDetails detail : this.details) {
            values.add(detail.getVmVendor());
        }
        return values.toArray(new String[values.size()]);
    }

    @Override
    public long getMemoryHeapInitInBytes() {
        long total = 0L;
        for (VirtualMachineDetails detail : this.details) {
            total += detail.getMemoryHeapInitInBytes();
        }
        return total;
    }

    @Override
    public double getMemoryHeapInitInMB() {
        return StatisticsUtils.convertToMB(this.getMemoryHeapInitInBytes());
    }

    @Override
    public double getMemoryHeapInitInGB() {
        return StatisticsUtils.convertToGB(this.getMemoryHeapInitInBytes());
    }

    @Override
    public long getMemoryHeapMaxInBytes() {
        long total = 0L;
        for (VirtualMachineDetails detail : this.details) {
            total += detail.getMemoryHeapMaxInBytes();
        }
        return total;
    }

    @Override
    public double getMemoryHeapMaxInMB() {
        return StatisticsUtils.convertToMB(this.getMemoryHeapMaxInBytes());
    }

    @Override
    public double getMemoryHeapMaxInGB() {
        return StatisticsUtils.convertToGB(this.getMemoryHeapMaxInBytes());
    }

    @Override
    public long getMemoryNonHeapInitInBytes() {
        long total = 0L;
        for (VirtualMachineDetails detail : this.details) {
            total += detail.getMemoryNonHeapInitInBytes();
        }
        return total;
    }

    @Override
    public double getMemoryNonHeapInitInMB() {
        return StatisticsUtils.convertToMB(this.getMemoryNonHeapInitInBytes());
    }

    @Override
    public double getMemoryNonHeapInitInGB() {
        return StatisticsUtils.convertToGB(this.getMemoryNonHeapInitInBytes());
    }

    @Override
    public long getMemoryNonHeapMaxInBytes() {
        long total = 0L;
        for (VirtualMachineDetails detail : this.details) {
            total += detail.getMemoryNonHeapMaxInBytes();
        }
        return total;
    }

    @Override
    public double getMemoryNonHeapMaxInMB() {
        return StatisticsUtils.convertToMB(this.getMemoryNonHeapMaxInBytes());
    }

    @Override
    public double getMemoryNonHeapMaxInGB() {
        return StatisticsUtils.convertToGB(this.getMemoryNonHeapMaxInBytes());
    }
}

