/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.vm;

import java.util.ArrayList;
import java.util.List;
import org.openspaces.admin.support.StatisticsUtils;
import org.openspaces.admin.vm.VirtualMachineStatistics;
import org.openspaces.admin.vm.VirtualMachinesDetails;
import org.openspaces.admin.vm.VirtualMachinesStatistics;

public class DefaultVirtualMachinesStatistics
implements VirtualMachinesStatistics {
    private final long timestamp = System.currentTimeMillis();
    private final VirtualMachineStatistics[] virutualMachinesStatistics;
    private final VirtualMachinesDetails details;
    private volatile VirtualMachinesStatistics previousStats;

    public DefaultVirtualMachinesStatistics(VirtualMachineStatistics[] virutualMachinesStatistics, VirtualMachinesDetails details, VirtualMachinesStatistics previousStats, int historySize) {
        this.virutualMachinesStatistics = virutualMachinesStatistics;
        this.details = details;
        this.previousStats = previousStats;
        VirtualMachinesStatistics lastStats = previousStats;
        if (lastStats != null) {
            for (int i = 0; i < historySize && lastStats.getPrevious() != null; ++i) {
                lastStats = lastStats.getPrevious();
            }
            ((DefaultVirtualMachinesStatistics)lastStats).setPreviousStats(null);
        }
    }

    @Override
    public boolean isNA() {
        return this.virutualMachinesStatistics == null || this.virutualMachinesStatistics.length == 0 || this.virutualMachinesStatistics[0].isNA();
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public long getPreviousTimestamp() {
        if (this.previousStats == null) {
            return -1L;
        }
        return this.previousStats.getTimestamp();
    }

    @Override
    public List<VirtualMachinesStatistics> getTimeline() {
        ArrayList<VirtualMachinesStatistics> timeline = new ArrayList<VirtualMachinesStatistics>();
        timeline.add(this);
        for (VirtualMachinesStatistics current = this.getPrevious(); current != null && !current.isNA(); current = current.getPrevious()) {
            timeline.add(current);
        }
        return timeline;
    }

    @Override
    public VirtualMachinesStatistics getPrevious() {
        return this.previousStats;
    }

    public void setPreviousStats(VirtualMachinesStatistics previousStats) {
        this.previousStats = previousStats;
    }

    @Override
    public int getSize() {
        return this.virutualMachinesStatistics.length;
    }

    @Override
    public VirtualMachinesDetails getDetails() {
        return this.details;
    }

    @Override
    public long getUptime() {
        long total = 0L;
        for (VirtualMachineStatistics stats : this.virutualMachinesStatistics) {
            total += stats.getUptime();
        }
        return total;
    }

    @Override
    public long getMemoryHeapCommittedInBytes() {
        long total = 0L;
        for (VirtualMachineStatistics stats : this.virutualMachinesStatistics) {
            if (stats.isNA()) continue;
            total += stats.getMemoryHeapCommittedInBytes();
        }
        return total;
    }

    @Override
    public double getMemoryHeapCommittedInMB() {
        return StatisticsUtils.convertToMB(this.getMemoryHeapCommittedInBytes());
    }

    @Override
    public double getMemoryHeapCommittedInGB() {
        return StatisticsUtils.convertToGB(this.getMemoryHeapCommittedInBytes());
    }

    @Override
    public long getMemoryHeapUsedInBytes() {
        long total = 0L;
        for (VirtualMachineStatistics stats : this.virutualMachinesStatistics) {
            if (stats.isNA()) continue;
            total += stats.getMemoryHeapUsedInBytes();
        }
        return total;
    }

    @Override
    public double getMemoryHeapUsedInMB() {
        return StatisticsUtils.convertToMB(this.getMemoryHeapUsedInBytes());
    }

    @Override
    public double getMemoryHeapUsedInGB() {
        return StatisticsUtils.convertToGB(this.getMemoryHeapUsedInBytes());
    }

    @Override
    public double getMemoryHeapUsedPerc() {
        return StatisticsUtils.computePerc(this.getMemoryHeapUsedInBytes(), this.getDetails().getMemoryHeapMaxInBytes());
    }

    @Override
    public double getMemoryHeapCommittedUsedPerc() {
        return StatisticsUtils.computePerc(this.getMemoryHeapUsedInBytes(), this.getMemoryHeapCommittedInBytes());
    }

    @Override
    public long getMemoryNonHeapCommittedInBytes() {
        long total = 0L;
        for (VirtualMachineStatistics stats : this.virutualMachinesStatistics) {
            if (stats.isNA()) continue;
            total += stats.getMemoryNonHeapCommittedInBytes();
        }
        return total;
    }

    @Override
    public double getMemoryNonHeapCommittedInMB() {
        return StatisticsUtils.convertToMB(this.getMemoryNonHeapCommittedInBytes());
    }

    @Override
    public double getMemoryNonHeapCommittedInGB() {
        return StatisticsUtils.convertToGB(this.getMemoryNonHeapCommittedInBytes());
    }

    @Override
    public long getMemoryNonHeapUsedInBytes() {
        long total = 0L;
        for (VirtualMachineStatistics stats : this.virutualMachinesStatistics) {
            if (stats.isNA()) continue;
            total += stats.getMemoryNonHeapUsedInBytes();
        }
        return total;
    }

    @Override
    public double getMemoryNonHeapUsedInMB() {
        return StatisticsUtils.convertToMB(this.getMemoryNonHeapUsedInBytes());
    }

    @Override
    public double getMemoryNonHeapUsedInGB() {
        return StatisticsUtils.convertToGB(this.getMemoryNonHeapUsedInBytes());
    }

    @Override
    public double getMemoryNonHeapUsedPerc() {
        return StatisticsUtils.computePerc(this.getMemoryNonHeapUsedInBytes(), this.getDetails().getMemoryNonHeapMaxInBytes());
    }

    @Override
    public double getMemoryNonHeapCommittedUsedPerc() {
        return StatisticsUtils.computePerc(this.getMemoryNonHeapUsedInBytes(), this.getMemoryNonHeapCommittedInBytes());
    }

    @Override
    public int getThreadCount() {
        int total = 0;
        for (VirtualMachineStatistics stats : this.virutualMachinesStatistics) {
            if (stats.isNA()) continue;
            total += stats.getThreadCount();
        }
        return total;
    }

    @Override
    public int getPeakThreadCount() {
        int total = 0;
        for (VirtualMachineStatistics stats : this.virutualMachinesStatistics) {
            if (stats.isNA()) continue;
            total += stats.getPeakThreadCount();
        }
        return total;
    }

    @Override
    public long getGcCollectionCount() {
        long total = 0L;
        for (VirtualMachineStatistics stats : this.virutualMachinesStatistics) {
            if (stats.isNA()) continue;
            total += stats.getGcCollectionCount();
        }
        return total;
    }

    @Override
    public long getGcCollectionTime() {
        long total = 0L;
        for (VirtualMachineStatistics stats : this.virutualMachinesStatistics) {
            if (stats.isNA()) continue;
            total += stats.getGcCollectionTime();
        }
        return total;
    }

    @Override
    public double getGcCollectionPerc() {
        double total = 0.0;
        int size = 0;
        for (VirtualMachineStatistics stats : this.virutualMachinesStatistics) {
            double perc = stats.getGcCollectionPerc();
            if (perc == -1.0) continue;
            total += perc;
            ++size;
        }
        if (size == 0) {
            return 0.0;
        }
        return total / (double)size;
    }
}

