/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.vm.events;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.support.GroovyHelper;
import org.openspaces.admin.internal.vm.InternalVirtualMachines;
import org.openspaces.admin.internal.vm.events.ClosureVirtualMachineAddedEventListener;
import org.openspaces.admin.internal.vm.events.InternalVirtualMachineAddedEventManager;
import org.openspaces.admin.vm.VirtualMachine;
import org.openspaces.admin.vm.events.VirtualMachineAddedEventListener;

public class DefaultVirtualMachineAddedEventManager
implements InternalVirtualMachineAddedEventManager {
    private final InternalVirtualMachines virtualMachines;
    private final InternalAdmin admin;
    private final List<VirtualMachineAddedEventListener> eventListeners = new CopyOnWriteArrayList<VirtualMachineAddedEventListener>();

    public DefaultVirtualMachineAddedEventManager(InternalVirtualMachines virtualMachines) {
        this.virtualMachines = virtualMachines;
        this.admin = (InternalAdmin)virtualMachines.getAdmin();
    }

    @Override
    public void virtualMachineAdded(final VirtualMachine virtualMachine) {
        for (final VirtualMachineAddedEventListener listener : this.eventListeners) {
            this.admin.pushEvent(listener, new Runnable(){

                @Override
                public void run() {
                    listener.virtualMachineAdded(virtualMachine);
                }
            });
        }
    }

    @Override
    public void add(final VirtualMachineAddedEventListener eventListener, boolean includeExisting) {
        if (includeExisting) {
            this.admin.raiseEvent(eventListener, new Runnable(){

                @Override
                public void run() {
                    for (VirtualMachine virtualMachine : DefaultVirtualMachineAddedEventManager.this.virtualMachines) {
                        eventListener.virtualMachineAdded(virtualMachine);
                    }
                }
            });
        }
        this.eventListeners.add(eventListener);
    }

    @Override
    public void add(VirtualMachineAddedEventListener eventListener) {
        this.add(eventListener, true);
    }

    @Override
    public void remove(VirtualMachineAddedEventListener eventListener) {
        this.eventListeners.remove(eventListener);
    }

    public void plus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.add(new ClosureVirtualMachineAddedEventListener(eventListener));
        } else {
            this.add((VirtualMachineAddedEventListener)eventListener);
        }
    }

    public void leftShift(Object eventListener) {
        this.plus(eventListener);
    }

    public void minus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.remove(new ClosureVirtualMachineAddedEventListener(eventListener));
        } else {
            this.remove((VirtualMachineAddedEventListener)eventListener);
        }
    }

    public void rightShift(Object eventListener) {
        this.minus(eventListener);
    }
}

