/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.vm.events;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.support.GroovyHelper;
import org.openspaces.admin.internal.vm.InternalVirtualMachines;
import org.openspaces.admin.internal.vm.events.ClosureVirtualMachineRemovedEventListener;
import org.openspaces.admin.internal.vm.events.InternalVirtualMachineRemovedEventManager;
import org.openspaces.admin.vm.VirtualMachine;
import org.openspaces.admin.vm.events.VirtualMachineRemovedEventListener;

public class DefaultVirtualMachineRemovedEventManager
implements InternalVirtualMachineRemovedEventManager {
    private final InternalVirtualMachines virtualMachines;
    private final InternalAdmin admin;
    private final List<VirtualMachineRemovedEventListener> eventListeners = new CopyOnWriteArrayList<VirtualMachineRemovedEventListener>();

    public DefaultVirtualMachineRemovedEventManager(InternalVirtualMachines virtualMachines) {
        this.virtualMachines = virtualMachines;
        this.admin = (InternalAdmin)virtualMachines.getAdmin();
    }

    @Override
    public void virtualMachineRemoved(final VirtualMachine virtualMachine) {
        for (final VirtualMachineRemovedEventListener listener : this.eventListeners) {
            this.admin.pushEvent(listener, new Runnable(){

                @Override
                public void run() {
                    listener.virtualMachineRemoved(virtualMachine);
                }
            });
        }
    }

    @Override
    public void add(VirtualMachineRemovedEventListener eventListener) {
        this.eventListeners.add(eventListener);
    }

    @Override
    public void remove(VirtualMachineRemovedEventListener eventListener) {
        this.eventListeners.remove(eventListener);
    }

    public void plus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.add(new ClosureVirtualMachineRemovedEventListener(eventListener));
        } else {
            this.add((VirtualMachineRemovedEventListener)eventListener);
        }
    }

    public void leftShift(Object eventListener) {
        this.plus(eventListener);
    }

    public void minus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.remove(new ClosureVirtualMachineRemovedEventListener(eventListener));
        } else {
            this.remove((VirtualMachineRemovedEventListener)eventListener);
        }
    }

    public void rightShift(Object eventListener) {
        this.minus(eventListener);
    }
}

