/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.vm.events;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.support.GroovyHelper;
import org.openspaces.admin.internal.vm.events.ClosureVirtualMachineStatisticsChangedEventListener;
import org.openspaces.admin.internal.vm.events.InternalVirtualMachineStatisticsChangedEventManager;
import org.openspaces.admin.vm.VirtualMachine;
import org.openspaces.admin.vm.VirtualMachineStatistics;
import org.openspaces.admin.vm.VirtualMachines;
import org.openspaces.admin.vm.events.VirtualMachineStatisticsChangedEvent;
import org.openspaces.admin.vm.events.VirtualMachineStatisticsChangedEventListener;

public class DefaultVirtualMachineStatisticsChangedEventManager
implements InternalVirtualMachineStatisticsChangedEventManager {
    private final InternalAdmin admin;
    private final VirtualMachine virtualMachine;
    private final VirtualMachines virtualMachines;
    private final List<VirtualMachineStatisticsChangedEventListener> eventListeners = new CopyOnWriteArrayList<VirtualMachineStatisticsChangedEventListener>();

    public DefaultVirtualMachineStatisticsChangedEventManager(InternalAdmin admin, VirtualMachines virtualMachines) {
        this.admin = admin;
        this.virtualMachines = virtualMachines;
        this.virtualMachine = null;
    }

    public DefaultVirtualMachineStatisticsChangedEventManager(InternalAdmin admin, VirtualMachine virtualMachine) {
        this.admin = admin;
        this.virtualMachine = virtualMachine;
        this.virtualMachines = null;
    }

    @Override
    public void virtualMachineStatisticsChanged(final VirtualMachineStatisticsChangedEvent event) {
        for (final VirtualMachineStatisticsChangedEventListener listener : this.eventListeners) {
            this.admin.raiseEvent(listener, new Runnable(){

                @Override
                public void run() {
                    listener.virtualMachineStatisticsChanged(event);
                }
            });
        }
    }

    @Override
    public void add(VirtualMachineStatisticsChangedEventListener eventListener) {
        this.add(eventListener, false);
    }

    @Override
    public void add(final VirtualMachineStatisticsChangedEventListener eventListener, boolean withHistory) {
        if (withHistory) {
            ArrayList<VirtualMachine> vms = new ArrayList<VirtualMachine>();
            if (this.virtualMachines != null) {
                vms.addAll(Arrays.asList(this.virtualMachines.getVirtualMachines()));
            } else if (this.virtualMachine != null) {
                vms.add(this.virtualMachine);
            }
            for (final VirtualMachine vm : vms) {
                VirtualMachineStatistics stats = vm.getStatistics();
                if (stats.isNA()) continue;
                List<VirtualMachineStatistics> timeline = stats.getTimeline();
                Collections.reverse(timeline);
                for (final VirtualMachineStatistics virtualMachineStatistics : timeline) {
                    this.admin.raiseEvent(eventListener, new Runnable(){

                        @Override
                        public void run() {
                            eventListener.virtualMachineStatisticsChanged(new VirtualMachineStatisticsChangedEvent(vm, virtualMachineStatistics));
                        }
                    });
                }
            }
        }
        this.eventListeners.add(eventListener);
    }

    @Override
    public void remove(VirtualMachineStatisticsChangedEventListener eventListener) {
        this.eventListeners.remove(eventListener);
    }

    public void plus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.add(new ClosureVirtualMachineStatisticsChangedEventListener(eventListener));
        } else {
            this.add((VirtualMachineStatisticsChangedEventListener)eventListener);
        }
    }

    public void leftShift(Object eventListener) {
        this.plus(eventListener);
    }

    public void minus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.remove(new ClosureVirtualMachineStatisticsChangedEventListener(eventListener));
        } else {
            this.remove((VirtualMachineStatisticsChangedEventListener)eventListener);
        }
    }

    public void rightShift(Object eventListener) {
        this.minus(eventListener);
    }
}

