/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.vm.events;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.support.GroovyHelper;
import org.openspaces.admin.internal.vm.events.ClosureVirtualMachinesStatisticsChangedEventListener;
import org.openspaces.admin.internal.vm.events.InternalVirtualMachinesStatisticsChangedEventManager;
import org.openspaces.admin.vm.VirtualMachines;
import org.openspaces.admin.vm.VirtualMachinesStatistics;
import org.openspaces.admin.vm.events.VirtualMachinesStatisticsChangedEvent;
import org.openspaces.admin.vm.events.VirtualMachinesStatisticsChangedEventListener;

public class DefaultVirtualMachinesStatisticsChangedEventManager
implements InternalVirtualMachinesStatisticsChangedEventManager {
    private final InternalAdmin admin;
    private final VirtualMachines virtualMachines;
    private final List<VirtualMachinesStatisticsChangedEventListener> eventListeners = new CopyOnWriteArrayList<VirtualMachinesStatisticsChangedEventListener>();

    public DefaultVirtualMachinesStatisticsChangedEventManager(InternalAdmin admin, VirtualMachines virtualMachines) {
        this.admin = admin;
        this.virtualMachines = virtualMachines;
    }

    @Override
    public void virtualMachinesStatisticsChanged(final VirtualMachinesStatisticsChangedEvent event) {
        for (final VirtualMachinesStatisticsChangedEventListener listener : this.eventListeners) {
            this.admin.raiseEvent(listener, new Runnable(){

                @Override
                public void run() {
                    listener.virtualMachinesStatisticsChanged(event);
                }
            });
        }
    }

    @Override
    public void add(VirtualMachinesStatisticsChangedEventListener eventListener) {
        this.add(eventListener, false);
    }

    @Override
    public void add(final VirtualMachinesStatisticsChangedEventListener eventListener, boolean withHistory) {
        VirtualMachinesStatistics stats;
        if (withHistory && !(stats = this.virtualMachines.getStatistics()).isNA()) {
            List<VirtualMachinesStatistics> timeline = stats.getTimeline();
            Collections.reverse(timeline);
            for (final VirtualMachinesStatistics virtualMachineStatistics : timeline) {
                this.admin.raiseEvent(eventListener, new Runnable(){

                    @Override
                    public void run() {
                        eventListener.virtualMachinesStatisticsChanged(new VirtualMachinesStatisticsChangedEvent(DefaultVirtualMachinesStatisticsChangedEventManager.this.virtualMachines, virtualMachineStatistics));
                    }
                });
            }
        }
        this.eventListeners.add(eventListener);
    }

    @Override
    public void remove(VirtualMachinesStatisticsChangedEventListener eventListener) {
        this.eventListeners.remove(eventListener);
    }

    public void plus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.add(new ClosureVirtualMachinesStatisticsChangedEventListener(eventListener));
        } else {
            this.add((VirtualMachinesStatisticsChangedEventListener)eventListener);
        }
    }

    public void leftShift(Object eventListener) {
        this.plus(eventListener);
    }

    public void minus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.remove(new ClosureVirtualMachinesStatisticsChangedEventListener(eventListener));
        } else {
            this.remove((VirtualMachinesStatisticsChangedEventListener)eventListener);
        }
    }

    public void rightShift(Object eventListener) {
        this.minus(eventListener);
    }
}

