/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.zone;

import java.util.Map;
import org.openspaces.admin.AdminException;
import org.openspaces.admin.dump.CompoundDumpResult;
import org.openspaces.admin.dump.DumpResult;
import org.openspaces.admin.esm.ElasticServiceManager;
import org.openspaces.admin.esm.ElasticServiceManagers;
import org.openspaces.admin.gsa.GridServiceAgent;
import org.openspaces.admin.gsa.GridServiceAgents;
import org.openspaces.admin.gsc.GridServiceContainer;
import org.openspaces.admin.gsc.GridServiceContainers;
import org.openspaces.admin.gsm.GridServiceManager;
import org.openspaces.admin.gsm.GridServiceManagers;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.esm.DefaultElasticServiceManagers;
import org.openspaces.admin.internal.esm.InternalElasticServiceManagers;
import org.openspaces.admin.internal.gsa.DefaultGridServiceAgents;
import org.openspaces.admin.internal.gsa.InternalGridServiceAgents;
import org.openspaces.admin.internal.gsc.DefaultGridServiceContainers;
import org.openspaces.admin.internal.gsc.InternalGridServiceContainers;
import org.openspaces.admin.internal.gsm.DefaultGridServiceManagers;
import org.openspaces.admin.internal.gsm.InternalGridServiceManagers;
import org.openspaces.admin.internal.lus.DefaultLookupServices;
import org.openspaces.admin.internal.lus.InternalLookupServices;
import org.openspaces.admin.internal.machine.DefaultMachines;
import org.openspaces.admin.internal.machine.InternalMachines;
import org.openspaces.admin.internal.pu.DefaultProcessingUnitInstances;
import org.openspaces.admin.internal.pu.InternalProcessingUnitInstances;
import org.openspaces.admin.internal.space.DefaultSpaceInstances;
import org.openspaces.admin.internal.space.InternalSpaceInstances;
import org.openspaces.admin.internal.transport.DefaultTransports;
import org.openspaces.admin.internal.transport.InternalTransports;
import org.openspaces.admin.internal.vm.DefaultVirtualMachines;
import org.openspaces.admin.internal.vm.InternalVirtualMachines;
import org.openspaces.admin.internal.zone.InternalZone;
import org.openspaces.admin.lus.LookupService;
import org.openspaces.admin.lus.LookupServices;
import org.openspaces.admin.machine.Machines;
import org.openspaces.admin.pu.ProcessingUnitInstance;
import org.openspaces.admin.pu.events.ProcessingUnitInstanceAddedEventManager;
import org.openspaces.admin.pu.events.ProcessingUnitInstanceLifecycleEventListener;
import org.openspaces.admin.pu.events.ProcessingUnitInstanceRemovedEventManager;
import org.openspaces.admin.space.SpaceInstance;
import org.openspaces.admin.space.events.SpaceInstanceAddedEventManager;
import org.openspaces.admin.space.events.SpaceInstanceLifecycleEventListener;
import org.openspaces.admin.space.events.SpaceInstanceRemovedEventManager;
import org.openspaces.admin.transport.Transports;
import org.openspaces.admin.vm.VirtualMachines;

public class DefaultZone
implements InternalZone {
    private final String name;
    private final InternalAdmin admin;
    private final InternalMachines machines;
    private final InternalLookupServices lookupServices;
    private final InternalGridServiceAgents gridServiceAgents;
    private final InternalGridServiceManagers gridServiceManagers;
    private final InternalElasticServiceManagers elasticServiceManagers;
    private final InternalGridServiceContainers gridServiceContainers;
    private final InternalTransports transports;
    private final InternalVirtualMachines virtualMachines;
    private final InternalProcessingUnitInstances processingUnitInstances;
    private final InternalSpaceInstances spaceInstances;

    public DefaultZone(InternalAdmin admin, String name) {
        this.admin = admin;
        this.name = name;
        this.machines = new DefaultMachines(admin);
        this.gridServiceAgents = new DefaultGridServiceAgents(admin);
        this.lookupServices = new DefaultLookupServices(admin);
        this.gridServiceManagers = new DefaultGridServiceManagers(admin);
        this.elasticServiceManagers = new DefaultElasticServiceManagers(admin);
        this.gridServiceContainers = new DefaultGridServiceContainers(admin);
        this.virtualMachines = new DefaultVirtualMachines(admin);
        this.processingUnitInstances = new DefaultProcessingUnitInstances(admin);
        this.spaceInstances = new DefaultSpaceInstances(admin);
        this.transports = new DefaultTransports(admin);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Machines getMachines() {
        return this.machines;
    }

    @Override
    public GridServiceAgents getGridServiceAgents() {
        return this.gridServiceAgents;
    }

    @Override
    public LookupServices getLookupServices() {
        return this.lookupServices;
    }

    @Override
    public GridServiceManagers getGridServiceManagers() {
        return this.gridServiceManagers;
    }

    @Override
    public ElasticServiceManagers getElasticServiceManagers() {
        return this.elasticServiceManagers;
    }

    @Override
    public GridServiceContainers getGridServiceContainers() {
        return this.gridServiceContainers;
    }

    @Override
    public boolean hasGridComponents() {
        return !this.gridServiceAgents.isEmpty() || !this.gridServiceManagers.isEmpty() || !this.elasticServiceManagers.isEmpty() || !this.gridServiceContainers.isEmpty() || !this.lookupServices.isEmpty();
    }

    @Override
    public Transports getTransports() {
        return this.transports;
    }

    @Override
    public VirtualMachines getVirtualMachines() {
        return this.virtualMachines;
    }

    @Override
    public ProcessingUnitInstanceAddedEventManager getProcessingUnitInstanceAdded() {
        return this.processingUnitInstances.getProcessingUnitInstanceAdded();
    }

    @Override
    public ProcessingUnitInstanceRemovedEventManager getProcessingUnitInstanceRemoved() {
        return this.processingUnitInstances.getProcessingUnitInstanceRemoved();
    }

    @Override
    public void addProcessingUnitInstanceLifecycleEventListener(ProcessingUnitInstanceLifecycleEventListener eventListener) {
        this.processingUnitInstances.addProcessingUnitInstanceLifecycleEventListener(eventListener);
    }

    @Override
    public void removeProcessingUnitInstanceLifecycleEventListener(ProcessingUnitInstanceLifecycleEventListener eventListener) {
        this.processingUnitInstances.removeProcessingUnitInstanceLifecycleEventListener(eventListener);
    }

    @Override
    public ProcessingUnitInstance[] getProcessingUnitInstances() {
        return this.processingUnitInstances.getInstances();
    }

    @Override
    public SpaceInstance[] getSpaceInstances() {
        return this.spaceInstances.getSpaceInstances();
    }

    @Override
    public SpaceInstanceAddedEventManager getSpaceInstanceAdded() {
        return this.spaceInstances.getSpaceInstanceAdded();
    }

    @Override
    public SpaceInstanceRemovedEventManager getSpaceInstanceRemoved() {
        return this.spaceInstances.getSpaceInstanceRemoved();
    }

    @Override
    public void addLifecycleListener(SpaceInstanceLifecycleEventListener eventListener) {
        this.spaceInstances.addLifecycleListener(eventListener);
    }

    @Override
    public void removeLifecycleListener(SpaceInstanceLifecycleEventListener eventListener) {
        this.spaceInstances.removeLifecycleListener(eventListener);
    }

    @Override
    public void addProcessingUnitInstance(ProcessingUnitInstance processingUnitInstance) {
        this.processingUnitInstances.addInstance(processingUnitInstance);
    }

    @Override
    public void removeProcessingUnitInstance(String uid) {
        this.processingUnitInstances.removeInstance(uid);
    }

    @Override
    public void addSpaceInstance(SpaceInstance spaceInstance) {
        this.spaceInstances.addSpaceInstance(spaceInstance);
    }

    @Override
    public void removeSpaceInstance(String uid) {
        this.spaceInstances.removeSpaceInstance(uid);
    }

    @Override
    public DumpResult generateDump(String cause, Map<String, Object> context) throws AdminException {
        return this.generateDump(cause, context, null);
    }

    @Override
    public DumpResult generateDump(String cause, Map<String, Object> context, String ... processor) throws AdminException {
        CompoundDumpResult dumpResult = new CompoundDumpResult();
        for (ElasticServiceManager esm : this.elasticServiceManagers) {
            dumpResult.add(esm.generateDump(cause, context, processor));
        }
        for (GridServiceManager gsm : this.gridServiceManagers) {
            dumpResult.add(gsm.generateDump(cause, context, processor));
        }
        for (GridServiceContainer gsc : this.gridServiceContainers) {
            dumpResult.add(gsc.generateDump(cause, context, processor));
        }
        for (GridServiceAgent gsa : this.gridServiceAgents) {
            dumpResult.add(gsa.generateDump(cause, context, processor));
        }
        for (LookupService lus : this.lookupServices) {
            dumpResult.add(lus.generateDump(cause, context, processor));
        }
        return dumpResult;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultZone that = (DefaultZone)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

