/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.zone;

import com.j_spaces.kernel.SizeConcurrentHashMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.openspaces.admin.Admin;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.zone.InternalZone;
import org.openspaces.admin.internal.zone.InternalZones;
import org.openspaces.admin.internal.zone.events.DefaultZoneAddedEventManager;
import org.openspaces.admin.internal.zone.events.DefaultZoneRemovedEventManager;
import org.openspaces.admin.internal.zone.events.InternalZoneAddedEventManager;
import org.openspaces.admin.internal.zone.events.InternalZoneRemovedEventManager;
import org.openspaces.admin.zone.Zone;
import org.openspaces.admin.zone.events.ZoneAddedEventListener;
import org.openspaces.admin.zone.events.ZoneAddedEventManager;
import org.openspaces.admin.zone.events.ZoneLifecycleEventListener;
import org.openspaces.admin.zone.events.ZoneRemovedEventManager;

public class DefaultZones
implements InternalZones {
    private final InternalAdmin admin;
    private final Map<String, Zone> zonesByName = new SizeConcurrentHashMap();
    private final Map<String, Set<String>> zonesProviders = new HashMap<String, Set<String>>();
    private final InternalZoneAddedEventManager zoneAddedEventManager;
    private final InternalZoneRemovedEventManager zoneRemovedEventManager;

    public DefaultZones(InternalAdmin admin) {
        this.admin = admin;
        this.zoneAddedEventManager = new DefaultZoneAddedEventManager(this);
        this.zoneRemovedEventManager = new DefaultZoneRemovedEventManager(this);
    }

    @Override
    public Zone[] getZones() {
        return this.zonesByName.values().toArray(new Zone[0]);
    }

    @Override
    public Zone getByName(String name) {
        return this.zonesByName.get(name);
    }

    @Override
    public Map<String, Zone> getNames() {
        return Collections.unmodifiableMap(this.zonesByName);
    }

    @Override
    public Admin getAdmin() {
        return this.admin;
    }

    @Override
    public Iterator<Zone> iterator() {
        return Collections.unmodifiableCollection(this.zonesByName.values()).iterator();
    }

    @Override
    public ZoneAddedEventManager getZoneAdded() {
        return this.zoneAddedEventManager;
    }

    @Override
    public ZoneRemovedEventManager getZoneRemoved() {
        return this.zoneRemovedEventManager;
    }

    @Override
    public void addLifecycleListener(ZoneLifecycleEventListener eventListener) {
        this.getZoneAdded().add(eventListener);
        this.getZoneRemoved().add(eventListener);
    }

    @Override
    public void removeLifeycleListener(ZoneLifecycleEventListener eventListener) {
        this.getZoneAdded().remove(eventListener);
        this.getZoneRemoved().remove(eventListener);
    }

    @Override
    public void addZone(InternalZone zone, String zoneUidProvider) {
        this.assertStateChangesPermitted();
        Set<String> providers = this.zonesProviders.get(zone.getName());
        if (providers == null) {
            providers = new HashSet<String>();
            this.zonesProviders.put(zone.getName(), providers);
        }
        providers.add(zoneUidProvider);
        Zone existing = this.zonesByName.put(zone.getName(), zone);
        if (existing == null) {
            this.zoneAddedEventManager.zoneAdded(zone);
        }
    }

    @Override
    public void removeProvider(Zone zone, String zoneUidProvider) {
        this.assertStateChangesPermitted();
        Set<String> providers = this.zonesProviders.get(zone.getName());
        if (providers != null) {
            Zone existingZone;
            providers.remove(zoneUidProvider);
            if (providers.isEmpty() && (existingZone = this.zonesByName.remove(zone.getName())) != null) {
                this.zoneRemovedEventManager.zoneRemoved(existingZone);
            }
        }
    }

    @Override
    public Zone waitFor(String zoneByName) {
        return this.waitFor(zoneByName, this.admin.getDefaultTimeout(), this.admin.getDefaultTimeoutTimeUnit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Zone waitFor(final String zoneByName, long timeout, TimeUnit timeUnit) {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference ref = new AtomicReference();
        ZoneAddedEventListener added = new ZoneAddedEventListener(){

            @Override
            public void zoneAdded(Zone zone) {
                if (zone.getName().equals(zoneByName)) {
                    ref.set(zone);
                    latch.countDown();
                }
            }
        };
        this.getZoneAdded().add(added);
        try {
            latch.await(timeout, timeUnit);
            Zone zone = (Zone)ref.get();
            return zone;
        }
        catch (InterruptedException e) {
            Zone zone = null;
            return zone;
        }
        finally {
            this.getZoneAdded().remove(added);
        }
    }

    private void assertStateChangesPermitted() {
        this.admin.assertStateChangesPermitted();
    }
}

