/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.zone.config;

import com.gigaspaces.internal.utils.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.openspaces.admin.AdminException;
import org.openspaces.admin.zone.config.ZonesConfig;

public class ZonesConfigUtils {
    private static final String UNIQUE_ZONES_DELIMITER = "__ZONE__";
    private static final CharSequence UNIQUE_DOT_DELIMITER = "__DOT__";

    public static String zonesToString(ZonesConfig zones) {
        ArrayList<String> sortedZones = new ArrayList<String>(zones.getZones());
        Collections.sort(sortedZones);
        for (String zone : sortedZones) {
            if (!zone.contains(UNIQUE_ZONES_DELIMITER)) continue;
            throw new IllegalArgumentException("Zone cannot contain the reserved __ZONE__ sequence");
        }
        sortedZones.add(0, zones.getClass().getName());
        String key = StringUtils.collectionToDelimitedString(sortedZones, (String)UNIQUE_ZONES_DELIMITER);
        String encodedKey = key.replace(".", UNIQUE_DOT_DELIMITER);
        return encodedKey;
    }

    public static ZonesConfig zonesFromString(String key) {
        ZonesConfig zonesConfig;
        Class<?> clazz;
        String decodedKey = key.replace(UNIQUE_DOT_DELIMITER, ".");
        ArrayList<String> sortedZones = new ArrayList<String>(Arrays.asList(StringUtils.delimitedListToStringArray((String)decodedKey, (String)UNIQUE_ZONES_DELIMITER)));
        String className = (String)sortedZones.remove(0);
        try {
            clazz = Class.forName(className);
        }
        catch (ClassCastException e) {
            throw new AdminException("Failed to create class " + className, e);
        }
        catch (ClassNotFoundException e) {
            throw new AdminException("Failed to create class " + className, e);
        }
        try {
            zonesConfig = (ZonesConfig)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new AdminException("Failed to launch " + clazz.getName() + " default constructor", e);
        }
        catch (SecurityException e) {
            throw new AdminException("Failed to launch " + clazz.getName() + " default constructor", e);
        }
        catch (InstantiationException e) {
            throw new AdminException("Failed to launch " + clazz.getName() + " default constructor", e);
        }
        catch (IllegalAccessException e) {
            throw new AdminException("Failed to launch " + clazz.getName() + " default constructor", e);
        }
        catch (InvocationTargetException e) {
            throw new AdminException("Failed to launch " + clazz.getName() + " default constructor", e);
        }
        catch (NoSuchMethodException e) {
            throw new AdminException("Failed to launch " + clazz.getName() + " default constructor", e);
        }
        zonesConfig.setZones(new HashSet<String>(sortedZones));
        return zonesConfig;
    }
}

