/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.zone.events;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.support.GroovyHelper;
import org.openspaces.admin.internal.zone.InternalZones;
import org.openspaces.admin.internal.zone.events.ClosureZoneAddedEventListener;
import org.openspaces.admin.internal.zone.events.InternalZoneAddedEventManager;
import org.openspaces.admin.zone.Zone;
import org.openspaces.admin.zone.events.ZoneAddedEventListener;

public class DefaultZoneAddedEventManager
implements InternalZoneAddedEventManager {
    private final InternalZones zones;
    private final InternalAdmin admin;
    private final List<ZoneAddedEventListener> zoneAddedEventListeners = new CopyOnWriteArrayList<ZoneAddedEventListener>();

    public DefaultZoneAddedEventManager(InternalZones zones) {
        this.zones = zones;
        this.admin = (InternalAdmin)zones.getAdmin();
    }

    @Override
    public void zoneAdded(final Zone zone) {
        for (final ZoneAddedEventListener listener : this.zoneAddedEventListeners) {
            this.admin.pushEventAsFirst(listener, new Runnable(){

                @Override
                public void run() {
                    listener.zoneAdded(zone);
                }
            });
        }
    }

    @Override
    public void add(final ZoneAddedEventListener eventListener) {
        this.admin.raiseEvent(eventListener, new Runnable(){

            @Override
            public void run() {
                for (Zone zone : DefaultZoneAddedEventManager.this.zones.getNames().values()) {
                    eventListener.zoneAdded(zone);
                }
            }
        });
        this.zoneAddedEventListeners.add(eventListener);
    }

    @Override
    public void remove(ZoneAddedEventListener eventListener) {
        this.zoneAddedEventListeners.remove(eventListener);
    }

    public void plus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.add(new ClosureZoneAddedEventListener(eventListener));
        } else {
            this.add((ZoneAddedEventListener)eventListener);
        }
    }

    public void leftShift(Object eventListener) {
        this.plus(eventListener);
    }

    public void minus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.remove(new ClosureZoneAddedEventListener(eventListener));
        } else {
            this.remove((ZoneAddedEventListener)eventListener);
        }
    }

    public void rightShift(Object eventListener) {
        this.minus(eventListener);
    }
}

