/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.internal.zone.events;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openspaces.admin.internal.admin.InternalAdmin;
import org.openspaces.admin.internal.support.GroovyHelper;
import org.openspaces.admin.internal.zone.InternalZones;
import org.openspaces.admin.internal.zone.events.ClosureZoneRemovedEventListener;
import org.openspaces.admin.internal.zone.events.InternalZoneRemovedEventManager;
import org.openspaces.admin.zone.Zone;
import org.openspaces.admin.zone.events.ZoneRemovedEventListener;

public class DefaultZoneRemovedEventManager
implements InternalZoneRemovedEventManager {
    private final InternalZones zones;
    private final InternalAdmin admin;
    private final List<ZoneRemovedEventListener> zoneRemovedEventListeners = new CopyOnWriteArrayList<ZoneRemovedEventListener>();

    public DefaultZoneRemovedEventManager(InternalZones zones) {
        this.zones = zones;
        this.admin = (InternalAdmin)zones.getAdmin();
    }

    @Override
    public void zoneRemoved(final Zone zone) {
        for (final ZoneRemovedEventListener listener : this.zoneRemovedEventListeners) {
            this.admin.pushEvent(listener, new Runnable(){

                @Override
                public void run() {
                    listener.zoneRemoved(zone);
                }
            });
        }
    }

    @Override
    public void add(ZoneRemovedEventListener eventListener) {
        this.zoneRemovedEventListeners.add(eventListener);
    }

    @Override
    public void remove(ZoneRemovedEventListener eventListener) {
        this.zoneRemovedEventListeners.remove(eventListener);
    }

    public void plus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.add(new ClosureZoneRemovedEventListener(eventListener));
        } else {
            this.add((ZoneRemovedEventListener)eventListener);
        }
    }

    public void leftShift(Object eventListener) {
        this.plus(eventListener);
    }

    public void minus(Object eventListener) {
        if (GroovyHelper.isClosure(eventListener)) {
            this.remove(new ClosureZoneRemovedEventListener(eventListener));
        } else {
            this.remove((ZoneRemovedEventListener)eventListener);
        }
    }

    public void rightShift(Object eventListener) {
        this.minus(eventListener);
    }
}

