/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.memcached;

import com.gigaspaces.security.directory.UserDetails;
import java.io.File;
import org.openspaces.admin.internal.pu.dependency.InternalProcessingUnitDependencies;
import org.openspaces.admin.internal.pu.dependency.ProcessingUnitDetailedDependencies;
import org.openspaces.admin.memcached.config.MemcachedConfig;
import org.openspaces.admin.pu.config.UserDetailsConfig;
import org.openspaces.admin.pu.dependency.ProcessingUnitDependency;
import org.openspaces.admin.pu.dependency.ProcessingUnitDeploymentDependenciesConfigurer;
import org.openspaces.admin.pu.topology.ProcessingUnitConfigHolder;
import org.openspaces.admin.pu.topology.ProcessingUnitDeploymentTopology;

public class MemcachedDeployment
implements ProcessingUnitDeploymentTopology {
    private final MemcachedConfig config = new MemcachedConfig();

    public MemcachedDeployment(String spaceUrl) {
        this.config.setSpaceUrl(spaceUrl);
    }

    public String getSpaceUrl() {
        return this.config.getSpaceUrl();
    }

    public MemcachedDeployment partitioned(int numberOfParitions, int numberOfBackups) {
        this.clusterSchema("partitioned");
        this.numberOfInstances(numberOfParitions);
        this.numberOfBackups(numberOfBackups);
        return this;
    }

    public MemcachedDeployment replicated(boolean async, int numberOfInstances) {
        if (async) {
            this.clusterSchema("async_replicated");
        } else {
            this.clusterSchema("sync_replicated");
        }
        this.numberOfInstances(numberOfInstances);
        this.numberOfBackups(0);
        return this;
    }

    public MemcachedDeployment clusterSchema(String clusterSchema) {
        this.config.setClusterSchema(clusterSchema);
        return this;
    }

    public MemcachedDeployment numberOfInstances(int numberOfInstances) {
        this.config.setNumberOfInstances(numberOfInstances);
        return this;
    }

    public MemcachedDeployment numberOfBackups(int numberOfBackups) {
        this.config.setNumberOfBackups(numberOfBackups);
        return this;
    }

    public MemcachedDeployment maxInstancesPerVM(int maxInstancesPerVM) {
        this.config.setMaxInstancesPerVM(maxInstancesPerVM);
        return this;
    }

    public MemcachedDeployment maxInstancesPerMachine(int maxInstancesPerMachine) {
        this.config.setMaxInstancesPerMachine(maxInstancesPerMachine);
        return this;
    }

    public MemcachedDeployment requiresIsolation(boolean requiresIsolation) {
        this.config.setRequiresIsolation(requiresIsolation);
        return this;
    }

    public MemcachedDeployment maxInstancesPerZone(String zone, int maxInstancesPerZone) {
        this.config.setMaxInstancesPerZone(zone, maxInstancesPerZone);
        return this;
    }

    public MemcachedDeployment addZone(String zone) {
        this.config.addZone(zone);
        return this;
    }

    public MemcachedDeployment setContextProperty(String key, String value) {
        this.config.setContextProperty(key, value);
        return this;
    }

    @Override
    public MemcachedDeployment secured(boolean secured) {
        this.config.setSecured(secured);
        return this;
    }

    @Override
    public MemcachedDeployment userDetails(UserDetails userDetails) {
        this.userDetails(userDetails.getUsername(), userDetails.getPassword());
        return this;
    }

    @Override
    public MemcachedDeployment userDetails(String userName, String password) {
        UserDetailsConfig userDetailsConfig = new UserDetailsConfig();
        userDetailsConfig.setUsername(userName);
        userDetailsConfig.setPassword(password);
        this.config.setUserDetails(userDetailsConfig);
        return this;
    }

    public MemcachedDeployment slaLocation(String slaLocation) {
        this.config.setSlaLocation(slaLocation);
        return this;
    }

    public MemcachedDeployment slaLocation(File slaLocation) {
        this.config.setSlaLocation(slaLocation.getAbsolutePath());
        return this;
    }

    @Override
    public MemcachedDeployment addDependencies(ProcessingUnitDetailedDependencies<? extends ProcessingUnitDependency> deploymentDependencies) {
        ((InternalProcessingUnitDependencies)this.config.getDependencies()).addDetailedDependencies(deploymentDependencies);
        return this;
    }

    @Override
    public MemcachedDeployment addDependency(String requiredProcessingUnitName) {
        this.addDependencies((ProcessingUnitDetailedDependencies)new ProcessingUnitDeploymentDependenciesConfigurer().dependsOnDeployed(requiredProcessingUnitName).create());
        return this;
    }

    @Override
    public ProcessingUnitConfigHolder create() {
        return this.config;
    }
}

