/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.pu;

import com.gigaspaces.security.directory.User;
import com.gigaspaces.security.directory.UserDetails;
import java.io.File;
import java.util.Map;
import org.openspaces.admin.internal.pu.dependency.InternalProcessingUnitDependencies;
import org.openspaces.admin.internal.pu.dependency.ProcessingUnitDetailedDependencies;
import org.openspaces.admin.pu.config.ProcessingUnitConfig;
import org.openspaces.admin.pu.config.UserDetailsConfig;
import org.openspaces.admin.pu.dependency.ProcessingUnitDependencies;
import org.openspaces.admin.pu.dependency.ProcessingUnitDependency;
import org.openspaces.admin.pu.dependency.ProcessingUnitDeploymentDependenciesConfigurer;
import org.openspaces.admin.pu.topology.ProcessingUnitConfigHolder;
import org.openspaces.admin.pu.topology.ProcessingUnitDeploymentTopology;

public class ProcessingUnitDeployment
implements ProcessingUnitDeploymentTopology {
    private final ProcessingUnitConfig config = new ProcessingUnitConfig();

    public ProcessingUnitDeployment(String processingUnitName) {
        this.config.setProcessingUnit(processingUnitName);
    }

    public ProcessingUnitDeployment(File processingUnit) {
        this(processingUnit.getAbsolutePath());
    }

    @Deprecated
    public String getProcessingUnit() {
        return this.config.getProcessingUnit();
    }

    public ProcessingUnitDeployment name(String name) {
        this.config.setName(name);
        return this;
    }

    public ProcessingUnitDeployment partitioned(int numberOfParitions, int numberOfBackups) {
        this.clusterSchema("partitioned");
        this.numberOfInstances(numberOfParitions);
        this.numberOfBackups(numberOfBackups);
        return this;
    }

    public ProcessingUnitDeployment replicated(boolean async, int numberOfInstances) {
        if (async) {
            this.clusterSchema("async_replicated");
        } else {
            this.clusterSchema("sync_replicated");
        }
        this.numberOfInstances(numberOfInstances);
        this.numberOfBackups(0);
        return this;
    }

    public ProcessingUnitDeployment clusterSchema(String clusterSchema) {
        this.config.setClusterSchema(clusterSchema);
        return this;
    }

    public ProcessingUnitDeployment numberOfInstances(int numberOfInstances) {
        this.config.setNumberOfInstances(numberOfInstances);
        return this;
    }

    public ProcessingUnitDeployment numberOfBackups(int numberOfBackups) {
        this.config.setNumberOfBackups(numberOfBackups);
        return this;
    }

    public ProcessingUnitDeployment requiresIsolation(boolean requiresIsolation) {
        this.config.setRequiresIsolation(requiresIsolation);
        return this;
    }

    public ProcessingUnitDeployment maxInstancesPerVM(int maxInstancesPerVM) {
        this.config.setMaxInstancesPerVM(maxInstancesPerVM);
        return this;
    }

    public ProcessingUnitDeployment maxInstancesPerMachine(int maxInstancesPerMachine) {
        this.config.setMaxInstancesPerMachine(maxInstancesPerMachine);
        return this;
    }

    public ProcessingUnitDeployment maxInstancesPerZone(String zone, int maxInstancesPerZone) {
        this.config.setMaxInstancesPerZone(zone, maxInstancesPerZone);
        return this;
    }

    public ProcessingUnitDeployment addZone(String zone) {
        this.config.addZone(zone);
        return this;
    }

    public ProcessingUnitDeployment primaryZone(String zone) {
        this.config.setPrimaryZone(zone);
        return this;
    }

    public ProcessingUnitDeployment addPrimaryZone(String primaryZone) {
        String primaryZones = this.config.getPrimaryZone();
        primaryZones = primaryZones == null || primaryZones.isEmpty() ? primaryZone : primaryZones + "," + primaryZone;
        this.config.setPrimaryZone(primaryZones);
        return this;
    }

    public ProcessingUnitDeployment setContextProperty(String key, String value) {
        this.config.getContextProperties().put(key, value);
        return this;
    }

    @Override
    public ProcessingUnitDeployment secured(boolean secured) {
        this.config.setSecured(secured);
        return this;
    }

    @Override
    public ProcessingUnitDeployment userDetails(UserDetails userDetails) {
        this.userDetails(userDetails.getUsername(), userDetails.getPassword());
        return this;
    }

    public ProcessingUnitDeployment slaLocation(String slaLocation) {
        this.config.setSlaLocation(slaLocation);
        return this;
    }

    public ProcessingUnitDeployment slaLocation(File slaLocation) {
        this.config.setSlaLocation(slaLocation.getAbsolutePath());
        return this;
    }

    @Override
    public ProcessingUnitDeployment userDetails(String userName, String password) {
        UserDetailsConfig userDetailsConfig = new UserDetailsConfig();
        userDetailsConfig.setUsername(userName);
        userDetailsConfig.setPassword(password);
        this.config.setUserDetails(userDetailsConfig);
        return this;
    }

    public Boolean isSecured() {
        return this.config.getSecured();
    }

    @Deprecated
    public UserDetails getUserDetails() {
        String username = this.config.getUserDetails().getUsername();
        String password = this.config.getUserDetails().getPassword();
        return new User(username, password);
    }

    @Override
    public ProcessingUnitDeployment addDependencies(ProcessingUnitDetailedDependencies<? extends ProcessingUnitDependency> detailedDependencies) {
        ((InternalProcessingUnitDependencies)this.config.getDependencies()).addDetailedDependencies(detailedDependencies);
        return this;
    }

    @Override
    public ProcessingUnitDeployment addDependency(String requiredProcessingUnitName) {
        this.addDependencies((ProcessingUnitDetailedDependencies)new ProcessingUnitDeploymentDependenciesConfigurer().dependsOnDeployed(requiredProcessingUnitName).create());
        return this;
    }

    @Deprecated
    public String[] getDeploymentOptions() {
        return this.config.toDeploymentOptions();
    }

    public ProcessingUnitDeployment setElasticProperty(String key, String value) {
        this.config.getElasticProperties().put(key, value);
        return this;
    }

    public void setDependencies(ProcessingUnitDependencies<ProcessingUnitDependency> dependencies) {
        this.config.setDependencies((InternalProcessingUnitDependencies)dependencies);
    }

    @Deprecated
    public Map<String, String> getElasticProperties() {
        return this.config.getElasticProperties();
    }

    @Override
    public ProcessingUnitConfigHolder create() {
        return this.config;
    }
}

