/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.pu.config;

import com.gigaspaces.grid.zone.ZoneHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.openspaces.admin.internal.pu.dependency.DefaultProcessingUnitDependencies;
import org.openspaces.admin.internal.pu.dependency.DefaultProcessingUnitDeploymentDependencies;
import org.openspaces.admin.internal.pu.dependency.InternalProcessingUnitDependencies;
import org.openspaces.admin.pu.config.ContextPropertyConfig;
import org.openspaces.admin.pu.config.MaxInstancesPerZoneConfig;
import org.openspaces.admin.pu.config.UserDetailsConfig;
import org.openspaces.admin.pu.dependency.ProcessingUnitDependencies;
import org.openspaces.admin.pu.dependency.ProcessingUnitDependency;
import org.openspaces.admin.pu.topology.ProcessingUnitConfigHolder;
import org.springframework.beans.factory.annotation.Required;

@XmlRootElement(name="pu")
public class ProcessingUnitConfig
implements ProcessingUnitConfigHolder {
    private String processingUnit;
    private String name;
    private String clusterSchema;
    private Integer numberOfInstances;
    private Integer numberOfBackups;
    private Boolean requiresIsolation;
    private Integer maxInstancesPerVM;
    private Integer maxInstancesPerMachine;
    private Map<String, Integer> maxInstancesPerZone = new HashMap<String, Integer>();
    private List<String> zones = new ArrayList<String>();
    private String primaryZone;
    private Map<String, String> contextProperties = new HashMap<String, String>();
    private UserDetailsConfig userDetails;
    private String slaLocation;
    private Boolean secured;
    private Map<String, String> elasticProperties = new HashMap<String, String>();
    private ProcessingUnitDependencies<ProcessingUnitDependency> dependencies = new DefaultProcessingUnitDependencies();

    public String getProcessingUnit() {
        return this.processingUnit;
    }

    @XmlAttribute
    @Required
    public void setProcessingUnit(String processingUnit) {
        this.processingUnit = processingUnit;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public String getClusterSchema() {
        return this.clusterSchema;
    }

    public void setClusterSchema(String clusterSchema) {
        this.clusterSchema = clusterSchema;
    }

    public Integer getNumberOfInstances() {
        return this.numberOfInstances;
    }

    public void setNumberOfInstances(Integer numberOfInstances) {
        this.numberOfInstances = numberOfInstances;
    }

    public Integer getNumberOfBackups() {
        return this.numberOfBackups;
    }

    public void setNumberOfBackups(Integer numberOfBackups) {
        this.numberOfBackups = numberOfBackups;
    }

    public Boolean isRequiresIsolation() {
        return this.requiresIsolation;
    }

    @XmlAttribute(name="requires-isolation")
    public void setRequiresIsolation(Boolean requiresIsolation) {
        this.requiresIsolation = requiresIsolation;
    }

    public Integer getMaxInstancesPerVM() {
        return this.maxInstancesPerVM;
    }

    @XmlAttribute(name="max-instances-per-vm")
    public void setMaxInstancesPerVM(Integer maxInstancesPerVM) {
        this.maxInstancesPerVM = maxInstancesPerVM;
    }

    public Integer getMaxInstancesPerMachine() {
        return this.maxInstancesPerMachine;
    }

    public void setMaxInstancesPerMachine(Integer maxInstancesPerMachine) {
        this.maxInstancesPerMachine = maxInstancesPerMachine;
    }

    @Override
    public Map<String, String> getContextProperties() {
        return this.contextProperties;
    }

    @Override
    public UserDetailsConfig getUserDetails() {
        return this.userDetails;
    }

    @Override
    @XmlElement(name="user-details")
    public void setUserDetails(UserDetailsConfig userDetails) {
        this.userDetails = userDetails;
    }

    public String getSlaLocation() {
        return this.slaLocation;
    }

    public void setSlaLocation(String slaLocation) {
        this.slaLocation = slaLocation;
    }

    @Override
    public Boolean getSecured() {
        return this.secured;
    }

    @Override
    public void setSecured(Boolean secured) {
        this.secured = secured;
    }

    public Map<String, String> getElasticProperties() {
        return this.elasticProperties;
    }

    public Map<String, Integer> getMaxInstancesPerZone() {
        return this.maxInstancesPerZone;
    }

    @XmlTransient
    public void setMaxInstancesPerZone(Map<String, Integer> maxInstancesPerZone) {
        this.maxInstancesPerZone = maxInstancesPerZone;
    }

    @XmlTransient
    public void setMaxInstancesPerZone(String zone, int maxInstancesPerZone) {
        this.getMaxInstancesPerZone().put(zone, maxInstancesPerZone);
    }

    @XmlElement(name="max-instances-per-zone")
    public void setMaxInstancesPerZoneConfig(MaxInstancesPerZoneConfig maxInstancesPerZoneConfig) {
        this.setMaxInstancesPerZone(maxInstancesPerZoneConfig.getZone(), maxInstancesPerZoneConfig.getMaxNumberOfInstances());
    }

    @Override
    public void setContextProperties(Map<String, String> contextProperties) {
        this.contextProperties = contextProperties;
    }

    @XmlTransient
    public void addContextProperties(Map<String, String> contextProperties) {
        this.contextProperties.putAll(contextProperties);
    }

    @XmlTransient
    public void setContextProperty(String key, String value) {
        this.contextProperties.put(key, value);
    }

    @XmlElement(name="context-property")
    public void setContextPropertyConfig(ContextPropertyConfig propertyConfig) {
        this.setContextProperty(propertyConfig.getKey(), propertyConfig.getValue());
    }

    public void setElasticProperties(Map<String, String> elasticProperties) {
        this.elasticProperties = elasticProperties;
    }

    public String[] toDeploymentOptions() {
        ArrayList<String> deployOptions = new ArrayList<String>();
        if (this.name != null) {
            deployOptions.add("-override-name");
            deployOptions.add(this.name);
        }
        if (this.slaLocation != null) {
            deployOptions.add("-sla");
            deployOptions.add(this.slaLocation);
        }
        if (this.clusterSchema != null || this.numberOfInstances != null || this.numberOfBackups != null) {
            deployOptions.add("-cluster");
            if (this.clusterSchema != null) {
                deployOptions.add("schema=" + this.clusterSchema);
            }
            if (this.numberOfInstances != null) {
                String totalMembers = "total_members=" + this.numberOfInstances;
                if (this.numberOfBackups != null) {
                    totalMembers = totalMembers + "," + this.numberOfBackups;
                }
                deployOptions.add(totalMembers);
            }
        }
        if (this.requiresIsolation != null) {
            deployOptions.add("-requires-isolation");
            deployOptions.add(this.requiresIsolation.toString());
        }
        if (this.maxInstancesPerVM != null) {
            deployOptions.add("-max-instances-per-vm");
            deployOptions.add(this.maxInstancesPerVM.toString());
        }
        if (this.maxInstancesPerMachine != null) {
            deployOptions.add("-max-instances-per-machine");
            deployOptions.add(this.maxInstancesPerMachine.toString());
        }
        if (!this.maxInstancesPerZone.isEmpty()) {
            deployOptions.add("-max-instances-per-zone");
            deployOptions.add(ZoneHelper.unparse(this.maxInstancesPerZone));
        }
        if (!this.zones.isEmpty()) {
            deployOptions.add("-zones");
            for (String string : this.zones) {
                deployOptions.add(string);
            }
        }
        if (this.primaryZone != null) {
            deployOptions.add("-primary-zone");
            deployOptions.add(this.primaryZone);
        }
        if (!this.elasticProperties.isEmpty()) {
            deployOptions.add("-elastic-properties");
            for (Map.Entry entry : this.elasticProperties.entrySet()) {
                deployOptions.add((String)entry.getKey() + "=" + (String)entry.getValue());
            }
        }
        for (Map.Entry entry : this.contextProperties.entrySet()) {
            deployOptions.add("-properties");
            deployOptions.add("embed://" + (String)entry.getKey() + "=" + (String)entry.getValue());
        }
        for (Iterator<Object> iterator : ((InternalProcessingUnitDependencies)this.getDependencies()).toCommandLineParameters()) {
            deployOptions.add("-" + iterator.getName());
            for (String arg : iterator.getArguments()) {
                deployOptions.add(arg);
            }
        }
        deployOptions.add(this.getProcessingUnit());
        return deployOptions.toArray(new String[deployOptions.size()]);
    }

    public String[] getZones() {
        return this.zones.toArray(new String[this.zones.size()]);
    }

    public void setZones(String[] zones) {
        this.zones = new ArrayList<String>(Arrays.asList(zones));
    }

    @XmlTransient
    public void addZone(String zone) {
        this.zones.add(zone);
    }

    @Override
    public ProcessingUnitDependencies<ProcessingUnitDependency> getDependencies() {
        return this.dependencies;
    }

    @Override
    @XmlTransient
    public void setDependencies(ProcessingUnitDependencies<ProcessingUnitDependency> dependencies) {
        this.dependencies = dependencies;
    }

    @XmlElement(type=ProcessingUnitDependency.class)
    public void setDeploymentDependencies(ProcessingUnitDependency[] dependencies) {
        DefaultProcessingUnitDeploymentDependencies deploymentDependencies = new DefaultProcessingUnitDeploymentDependencies();
        for (ProcessingUnitDependency dependency : dependencies) {
            deploymentDependencies.addDependency(dependency);
        }
        ((InternalProcessingUnitDependencies)this.getDependencies()).setDeploymentDependencies(deploymentDependencies);
    }

    public ProcessingUnitDependency[] getDeploymentDependencies() {
        ArrayList dependenciesAsList = new ArrayList();
        for (String name : this.getDependencies().getDeploymentDependencies().getRequiredProcessingUnitsNames()) {
            dependenciesAsList.add(this.getDependencies().getDeploymentDependencies().getDependencyByName(name));
        }
        return dependenciesAsList.toArray(new ProcessingUnitDependency[dependenciesAsList.size()]);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.clusterSchema == null ? 0 : this.clusterSchema.hashCode());
        result = 31 * result + (this.contextProperties == null ? 0 : this.contextProperties.hashCode());
        result = 31 * result + (this.dependencies == null ? 0 : this.dependencies.hashCode());
        result = 31 * result + (this.elasticProperties == null ? 0 : this.elasticProperties.hashCode());
        result = 31 * result + (this.maxInstancesPerMachine == null ? 0 : this.maxInstancesPerMachine.hashCode());
        result = 31 * result + (this.maxInstancesPerVM == null ? 0 : this.maxInstancesPerVM.hashCode());
        result = 31 * result + (this.requiresIsolation == null ? 0 : this.requiresIsolation.hashCode());
        result = 31 * result + (this.maxInstancesPerZone == null ? 0 : this.maxInstancesPerZone.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.numberOfBackups == null ? 0 : this.numberOfBackups.hashCode());
        result = 31 * result + (this.numberOfInstances == null ? 0 : this.numberOfInstances.hashCode());
        result = 31 * result + (this.processingUnit == null ? 0 : this.processingUnit.hashCode());
        result = 31 * result + (this.secured == null ? 0 : this.secured.hashCode());
        result = 31 * result + (this.slaLocation == null ? 0 : this.slaLocation.hashCode());
        result = 31 * result + (this.userDetails == null ? 0 : this.userDetails.hashCode());
        result = 31 * result + (this.zones == null ? 0 : this.zones.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProcessingUnitConfig other = (ProcessingUnitConfig)obj;
        if (this.clusterSchema == null ? other.clusterSchema != null : !this.clusterSchema.equals(other.clusterSchema)) {
            return false;
        }
        if (this.contextProperties == null ? other.contextProperties != null : !this.contextProperties.equals(other.contextProperties)) {
            return false;
        }
        if (this.dependencies == null ? other.dependencies != null : !this.dependencies.equals(other.dependencies)) {
            return false;
        }
        if (this.elasticProperties == null ? other.elasticProperties != null : !this.elasticProperties.equals(other.elasticProperties)) {
            return false;
        }
        if (this.maxInstancesPerMachine == null ? other.maxInstancesPerMachine != null : !this.maxInstancesPerMachine.equals(other.maxInstancesPerMachine)) {
            return false;
        }
        if (this.requiresIsolation == null ? other.requiresIsolation != null : !this.requiresIsolation.equals(other.requiresIsolation)) {
            return false;
        }
        if (this.maxInstancesPerVM == null ? other.maxInstancesPerVM != null : !this.maxInstancesPerVM.equals(other.maxInstancesPerVM)) {
            return false;
        }
        if (this.maxInstancesPerZone == null ? other.maxInstancesPerZone != null : !this.maxInstancesPerZone.equals(other.maxInstancesPerZone)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.numberOfBackups == null ? other.numberOfBackups != null : !this.numberOfBackups.equals(other.numberOfBackups)) {
            return false;
        }
        if (this.numberOfInstances == null ? other.numberOfInstances != null : !this.numberOfInstances.equals(other.numberOfInstances)) {
            return false;
        }
        if (this.processingUnit == null ? other.processingUnit != null : !this.processingUnit.equals(other.processingUnit)) {
            return false;
        }
        if (this.secured == null ? other.secured != null : !this.secured.equals(other.secured)) {
            return false;
        }
        if (this.slaLocation == null ? other.slaLocation != null : !this.slaLocation.equals(other.slaLocation)) {
            return false;
        }
        if (this.userDetails == null ? other.userDetails != null : !this.userDetails.equals(other.userDetails)) {
            return false;
        }
        if (this.zones == null ? other.zones != null : !this.zones.equals(other.zones)) {
            return false;
        }
        return !(this.primaryZone == null ? other.primaryZone != null : !this.primaryZone.equals(other.primaryZone));
    }

    public String toString() {
        return "ProcessingUnitConfig [" + (this.processingUnit != null ? "processingUnit=" + this.processingUnit + ", " : "") + (this.name != null ? "name=" + this.name + ", " : "") + (this.clusterSchema != null ? "clusterSchema=" + this.clusterSchema + ", " : "") + (this.numberOfInstances != null ? "numberOfInstances=" + this.numberOfInstances + ", " : "") + (this.numberOfBackups != null ? "numberOfBackups=" + this.numberOfBackups + ", " : "") + (this.requiresIsolation != null ? "requiresIsolation=" + this.requiresIsolation + ", " : "") + (this.maxInstancesPerVM != null ? "maxInstancesPerVM=" + this.maxInstancesPerVM + ", " : "") + (this.maxInstancesPerMachine != null ? "maxInstancesPerMachine=" + this.maxInstancesPerMachine + ", " : "") + (this.maxInstancesPerZone != null ? "maxInstancesPerZone=" + this.maxInstancesPerZone + ", " : "") + (this.zones != null ? "zones=" + this.zones + ", " : "") + (this.primaryZone != null ? "primaryZone=" + this.primaryZone + ", " : "") + (this.contextProperties != null ? "contextProperties=" + this.contextProperties + ", " : "") + (this.userDetails != null ? "userDetails=" + this.userDetails + ", " : "") + (this.slaLocation != null ? "slaLocation=" + this.slaLocation + ", " : "") + (this.secured != null ? "secured=" + this.secured + ", " : "") + (this.elasticProperties != null ? "elasticProperties=" + this.elasticProperties + ", " : "") + (this.dependencies != null ? "dependencies=" + this.dependencies : "") + "]";
    }

    public String getPrimaryZone() {
        return this.primaryZone;
    }

    public void setPrimaryZone(String primaryZone) {
        this.primaryZone = primaryZone;
    }

    @Override
    public ProcessingUnitConfig toProcessingUnitConfig() {
        return this;
    }
}

