/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.pu.dependency.config;

import javax.annotation.PostConstruct;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.jini.rio.core.RequiredDependency;
import org.openspaces.admin.internal.pu.dependency.InternalProcessingUnitDependency;
import org.openspaces.admin.pu.dependency.ProcessingUnitDependency;
import org.springframework.beans.factory.annotation.Required;

@XmlRootElement(name="depends-on")
public class ProcessingUnitDependencyConfig
implements InternalProcessingUnitDependency {
    private boolean waitForDeploymentToComplete;
    private int minimumNumberOfDeployedInstancesPerPartition;
    private int minimumNumberOfDeployedInstances;
    private String requiredProcessingUnitName;

    @Override
    public boolean getWaitForDeploymentToComplete() {
        return this.waitForDeploymentToComplete;
    }

    @Override
    @XmlAttribute(name="deployed")
    public void setWaitForDeploymentToComplete(boolean waitForDeploymentToComplete) {
        this.waitForDeploymentToComplete = waitForDeploymentToComplete;
    }

    @Override
    public int getMinimumNumberOfDeployedInstancesPerPartition() {
        return this.minimumNumberOfDeployedInstancesPerPartition;
    }

    @Override
    @XmlAttribute(name="min-instances-per-partition")
    public void setMinimumNumberOfDeployedInstancesPerPartition(int minimumNumberOfDeployedInstancesPerPartition) {
        this.minimumNumberOfDeployedInstancesPerPartition = minimumNumberOfDeployedInstancesPerPartition;
    }

    @Override
    public int getMinimumNumberOfDeployedInstances() {
        return this.minimumNumberOfDeployedInstances;
    }

    @Override
    @XmlAttribute(name="min-instances")
    public void setMinimumNumberOfDeployedInstances(int minimumNumberOfDeployedInstances) {
        this.minimumNumberOfDeployedInstances = minimumNumberOfDeployedInstances;
    }

    @Override
    public String getRequiredProcessingUnitName() {
        return this.requiredProcessingUnitName;
    }

    @Required
    @XmlAttribute(name="name")
    public void setRequiredProcessingUnitName(String requiredProcessingUnitName) {
        this.requiredProcessingUnitName = requiredProcessingUnitName;
    }

    @PostConstruct
    public void afterPropertiesSet() {
        if (!this.waitForDeploymentToComplete && this.minimumNumberOfDeployedInstances == 0 && this.minimumNumberOfDeployedInstancesPerPartition == 0) {
            this.waitForDeploymentToComplete = true;
        }
    }

    @Override
    public void mergeDependency(ProcessingUnitDependency otherDependency) {
        this.mergeDependency(((InternalProcessingUnitDependency)otherDependency).toRequiredDependency());
    }

    @Override
    public void mergeDependency(RequiredDependency otherRequiredDependency) {
        RequiredDependency requiredDependency = this.toRequiredDependency();
        requiredDependency.merge(otherRequiredDependency);
        this.requiredProcessingUnitName = requiredDependency.getRequiredProcessingUnitName();
        this.minimumNumberOfDeployedInstances = requiredDependency.getMinimumNumberOfDeployedInstances();
        this.minimumNumberOfDeployedInstancesPerPartition = requiredDependency.getMinimumNumberOfDeployedInstancesPerPartition();
        this.waitForDeploymentToComplete = requiredDependency.getWaitForDeploymentToComplete();
    }

    @Override
    public RequiredDependency toRequiredDependency() {
        RequiredDependency requiredDependency = new RequiredDependency(this.requiredProcessingUnitName);
        requiredDependency.setMinimumNumberOfDeployedInstances(this.minimumNumberOfDeployedInstances);
        requiredDependency.setMinimumNumberOfDeployedInstancesPerPartition(this.minimumNumberOfDeployedInstancesPerPartition);
        requiredDependency.setWaitForDeploymentToComplete(this.waitForDeploymentToComplete);
        return requiredDependency;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.minimumNumberOfDeployedInstances;
        result = 31 * result + this.minimumNumberOfDeployedInstancesPerPartition;
        result = 31 * result + (this.requiredProcessingUnitName == null ? 0 : this.requiredProcessingUnitName.hashCode());
        result = 31 * result + (this.waitForDeploymentToComplete ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProcessingUnitDependencyConfig other = (ProcessingUnitDependencyConfig)obj;
        if (this.minimumNumberOfDeployedInstances != other.minimumNumberOfDeployedInstances) {
            return false;
        }
        if (this.minimumNumberOfDeployedInstancesPerPartition != other.minimumNumberOfDeployedInstancesPerPartition) {
            return false;
        }
        if (this.requiredProcessingUnitName == null ? other.requiredProcessingUnitName != null : !this.requiredProcessingUnitName.equals(other.requiredProcessingUnitName)) {
            return false;
        }
        return this.waitForDeploymentToComplete == other.waitForDeploymentToComplete;
    }

    public String toString() {
        return "ProcessingUnitDependencyConfig [waitForDeploymentToComplete=" + this.waitForDeploymentToComplete + ", minimumNumberOfDeployedInstancesPerPartition=" + this.minimumNumberOfDeployedInstancesPerPartition + ", minimumNumberOfDeployedInstances=" + this.minimumNumberOfDeployedInstances + ", requiredProcessingUnitName=" + this.requiredProcessingUnitName + "]";
    }
}

