/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.pu.elastic.config;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.openspaces.admin.internal.pu.elastic.ScaleStrategyConfigUtils;
import org.openspaces.admin.pu.elastic.config.AutomaticCapacityScaleRuleConfig;
import org.openspaces.admin.pu.elastic.config.CapacityRequirementsConfig;
import org.openspaces.admin.pu.elastic.config.ScaleStrategyAgentZonesAwareConfig;
import org.openspaces.admin.pu.elastic.config.ScaleStrategyConfig;
import org.openspaces.core.util.StringProperties;
import org.openspaces.grid.gsm.strategy.AutomaticCapacityScaleStrategyBean;

@Deprecated
public class AutomaticCapacityScaleConfig
implements ScaleStrategyConfig,
ScaleStrategyAgentZonesAwareConfig,
Externalizable {
    private static final long serialVersionUID = 1L;
    private static final String STATISTICS_POLLING_INTERVAL_SECONDS_KEY = "statistics-polling-interval-seconds";
    private static final long STATISTICS_POLLING_INTERVAL_SECONDS_DEFAULT = 60L;
    private static final String COOLDOWN_AFTER_SCALEOUT_SECONDS_KEY = "cooldown-after-scaleout-seconds";
    private static final long COOLDOWN_AFTER_SCALEOUT_SECONDS_DEFAULT = 60L;
    private static final String COOLDOWN_AFTER_SCALEIN_SECONDS_KEY = "cooldown-after-scalein-seconds";
    private static final long COOLDOWN_AFTER_SCALEIN_SECONDS_DEFAULT = 60L;
    private static final String MIN_CAPACITY_KEY_PREFIX = "min-capacity.";
    private static final String INITIAL_CAPACITY_KEY_PREFIX = "initial-capacity.";
    private static final String MAX_CAPACITY_KEY_PREFIX = "max-capacity.";
    private static final String MIN_CAPACITY_PER_ZONE_KEY_PREFIX = "min-capacity-per-zone.";
    private static final String MAX_CAPACITY_PER_ZONE_KEY_PREFIX = "max-capacity-per-zone.";
    private static final HashMap<String, String> EMPTY_CAPACITY = new HashMap();
    private static final String RULE_KEY = "rule";
    private StringProperties properties;

    public AutomaticCapacityScaleConfig() {
        this.properties = new StringProperties();
    }

    public AutomaticCapacityScaleConfig(Map<String, String> properties) {
        this.properties = new StringProperties(properties);
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties.getProperties();
    }

    @Override
    public void setProperties(Map<String, String> properties) {
        this.properties = new StringProperties(properties);
    }

    @Override
    public String getBeanClassName() {
        return AutomaticCapacityScaleStrategyBean.class.getName();
    }

    @Override
    public int getMaxConcurrentRelocationsPerMachine() {
        return ScaleStrategyConfigUtils.getMaxConcurrentRelocationsPerMachine(this.properties);
    }

    @Override
    public void setMaxConcurrentRelocationsPerMachine(int maxNumberOfConcurrentRelocationsPerMachine) {
        ScaleStrategyConfigUtils.setMaxConcurrentRelocationsPerMachine(this.properties, maxNumberOfConcurrentRelocationsPerMachine);
    }

    @Override
    public void setAtMostOneConcurrentRelocation(boolean atMostOneConcurrentRelocation) {
        ScaleStrategyConfigUtils.setAtMostOneConcurrentRelocation(this.properties, atMostOneConcurrentRelocation);
    }

    @Override
    public boolean isAtMostOneConcurrentRelocation() {
        return ScaleStrategyConfigUtils.isAtMostOneConcurrentRelocation(this.properties);
    }

    @Override
    public void setAllowAboveAverageMemoryPerMachine(boolean allowAboveAverageMemoryPerMachine) {
        ScaleStrategyConfigUtils.setAllowAboveAverageMemoryPerMachine(this.properties, allowAboveAverageMemoryPerMachine);
    }

    @Override
    public boolean isAllowAboveAverageMemoryPerMachine() {
        return ScaleStrategyConfigUtils.isAllowAboveAverageMemoryPerMachine(this.properties);
    }

    @Override
    public void setPollingIntervalSeconds(int pollingTimeIntervalSeconds) {
        ScaleStrategyConfigUtils.setPollingIntervalSeconds(this.properties, pollingTimeIntervalSeconds);
    }

    @Override
    public int getPollingIntervalSeconds() {
        return ScaleStrategyConfigUtils.getPollingIntervalSeconds(this.properties);
    }

    @Override
    public boolean isAtMostOneContainerPerMachine() {
        return ScaleStrategyConfigUtils.isSingleContainerPerMachine(this.properties);
    }

    @Override
    public void setAtMostOneContainerPerMachine(boolean atMostOneContainerPerMachine) {
        ScaleStrategyConfigUtils.setAtMostOneContainerPerMachine(this.properties, atMostOneContainerPerMachine);
    }

    public void setStatisticsPollingIntervalSeconds(int statisticsPollingIntervalSeconds) {
        this.properties.putLong(STATISTICS_POLLING_INTERVAL_SECONDS_KEY, (long)statisticsPollingIntervalSeconds);
    }

    public long getStatisticsPollingIntervalSeconds() {
        return this.properties.getLong(STATISTICS_POLLING_INTERVAL_SECONDS_KEY, 60L);
    }

    public void setCooldownAfterScaleOutSeconds(long cooldownAfterInstanceAddedSeconds) {
        this.properties.putLong(COOLDOWN_AFTER_SCALEOUT_SECONDS_KEY, cooldownAfterInstanceAddedSeconds);
    }

    public long getCooldownAfterScaleOutSeconds() {
        return this.properties.getLong(COOLDOWN_AFTER_SCALEOUT_SECONDS_KEY, 60L);
    }

    @Deprecated
    public void setCooldownAfterScaleSeconds(long cooldownAfterInstanceRemovedSeconds) {
        this.setCooldownAfterScaleInSeconds(cooldownAfterInstanceRemovedSeconds);
    }

    public void setCooldownAfterScaleInSeconds(long cooldownAfterInstanceRemovedSeconds) {
        this.properties.putLong(COOLDOWN_AFTER_SCALEIN_SECONDS_KEY, cooldownAfterInstanceRemovedSeconds);
    }

    @Deprecated
    public long getCooldownAfterScaleSeconds() {
        return this.getCooldownAfterScaleInSeconds();
    }

    public long getCooldownAfterScaleInSeconds() {
        return this.properties.getLong(COOLDOWN_AFTER_SCALEIN_SECONDS_KEY, 60L);
    }

    public void setMinCapacity(CapacityRequirementsConfig minCapacity) {
        this.properties.putMap(MIN_CAPACITY_KEY_PREFIX, minCapacity.getProperties());
    }

    public CapacityRequirementsConfig getMinCapacity() {
        return new CapacityRequirementsConfig(this.properties.getMap(MIN_CAPACITY_KEY_PREFIX, EMPTY_CAPACITY));
    }

    public void setMaxCapacity(CapacityRequirementsConfig maxCapacity) {
        this.properties.putMap(MAX_CAPACITY_KEY_PREFIX, maxCapacity.getProperties());
    }

    public CapacityRequirementsConfig getMinCapacityPerZone() {
        return new CapacityRequirementsConfig(this.properties.getMap(MIN_CAPACITY_PER_ZONE_KEY_PREFIX, EMPTY_CAPACITY));
    }

    public void setMinCapacityPerZone(CapacityRequirementsConfig minCapacityPerZone) {
        this.properties.putMap(MIN_CAPACITY_PER_ZONE_KEY_PREFIX, minCapacityPerZone.getProperties());
    }

    public CapacityRequirementsConfig getMaxCapacityPerZone() {
        return new CapacityRequirementsConfig(this.properties.getMap(MAX_CAPACITY_PER_ZONE_KEY_PREFIX, EMPTY_CAPACITY));
    }

    public void setMaxCapacityPerZone(CapacityRequirementsConfig maxCapacityPerZone) {
        this.properties.putMap(MAX_CAPACITY_PER_ZONE_KEY_PREFIX, maxCapacityPerZone.getProperties());
    }

    public void setRules(AutomaticCapacityScaleRuleConfig[] rules) {
        for (int i = 0; i < rules.length; ++i) {
            this.properties.putMap(this.getRulesKeyPrefix(i), rules[i].getProperties());
        }
    }

    public AutomaticCapacityScaleRuleConfig[] getRules() {
        Map ruleProperties;
        ArrayList<AutomaticCapacityScaleRuleConfig> rules = new ArrayList<AutomaticCapacityScaleRuleConfig>();
        int i = 0;
        while ((ruleProperties = this.properties.getMap(this.getRulesKeyPrefix(i), null)) != null) {
            rules.add(new AutomaticCapacityScaleRuleConfig(ruleProperties));
            ++i;
        }
        return rules.toArray(new AutomaticCapacityScaleRuleConfig[rules.size()]);
    }

    private String getRulesKeyPrefix(int i) {
        return RULE_KEY + i + ".";
    }

    public CapacityRequirementsConfig getMaxCapacity() {
        return new CapacityRequirementsConfig(this.properties.getMap(MAX_CAPACITY_KEY_PREFIX, EMPTY_CAPACITY));
    }

    public void setInitialCapacity(CapacityRequirementsConfig initialCapacity) {
        this.properties.putMap(INITIAL_CAPACITY_KEY_PREFIX, initialCapacity.getProperties());
    }

    public CapacityRequirementsConfig getInitialCapacity() {
        return new CapacityRequirementsConfig(this.properties.getMap(INITIAL_CAPACITY_KEY_PREFIX, EMPTY_CAPACITY));
    }

    @Override
    public boolean isGridServiceAgentZonesAware() {
        return ScaleStrategyConfigUtils.isGridServiceAgentZonesAware(this.properties);
    }

    @Override
    public void setGridServiceAgentZonesAware(boolean enableAgentZonesAware) {
        ScaleStrategyConfigUtils.setGridServiceAgentZonesAware(this.properties, enableAgentZonesAware);
    }

    @Override
    public String toString() {
        return this.properties.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AutomaticCapacityScaleConfig other = (AutomaticCapacityScaleConfig)obj;
        return !(this.properties == null ? other.properties != null : !this.properties.equals((Object)other.properties));
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.properties.getProperties());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.properties = new StringProperties((Map)in.readObject());
    }
}

