/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.pu.elastic.config;

import java.util.HashMap;
import java.util.Map;
import org.openspaces.admin.pu.elastic.config.ScaleStrategyCapacityRequirementConfig;
import org.openspaces.core.util.StringProperties;
import org.openspaces.grid.gsm.capacity.CapacityRequirement;
import org.openspaces.grid.gsm.capacity.CapacityRequirements;
import org.openspaces.grid.gsm.capacity.CpuCapacityRequirement;
import org.openspaces.grid.gsm.capacity.DriveCapacityRequirement;
import org.openspaces.grid.gsm.capacity.MemoryCapacityRequirement;

@Deprecated
public class CapacityRequirementsConfig
implements ScaleStrategyCapacityRequirementConfig {
    private static final String MEMORY_CAPACITY_MEGABYTES_KEY = "memory-capacity-megabytes";
    private static final int MEMORY_CAPACITY_MEGABYTES_DEFAULT = 0;
    private static final String CPU_CAPACITY_CORES_KEY = "cpu-capacity-cores";
    private static final double CPU_CAPACITY_CORES_DEFAULT = 0.0;
    private static final String DRIVE_CAPACITY_MEGABYTES_KEY = "drive-capacity-megabytes";
    private static final String DRIVE_CAPACITY_MEGABYTES_PAIR_SEPERATOR = ",";
    private static final String DRIVE_CAPACITY_MEGABYTES_KEYVALUE_SEPERATOR = "=";
    private static final Map<String, String> DRIVE_CAPACITY_MEGABYTES_DEFAULT = new HashMap<String, String>();
    private StringProperties properties;

    public CapacityRequirementsConfig() {
        this.properties = new StringProperties();
    }

    public CapacityRequirementsConfig(Map<String, String> properties) {
        this.properties = new StringProperties(properties);
    }

    public CapacityRequirementsConfig(CapacityRequirements newCapacity) {
        this();
        long memoryInMB = 0L;
        HashMap<String, Long> megaBytesPerDrive = new HashMap<String, Long>();
        double cpuCores = 0.0;
        for (CapacityRequirement capacityRequirement : newCapacity.getRequirements()) {
            if (capacityRequirement instanceof MemoryCapacityRequirement) {
                MemoryCapacityRequirement memoryCapacityRequirement = (MemoryCapacityRequirement)capacityRequirement;
                memoryInMB += memoryCapacityRequirement.getMemoryInMB();
                continue;
            }
            if (capacityRequirement instanceof DriveCapacityRequirement) {
                DriveCapacityRequirement driveCapacityRequirement = (DriveCapacityRequirement)capacityRequirement;
                megaBytesPerDrive.put(driveCapacityRequirement.getDrive(), driveCapacityRequirement.getDriveCapacityInMB());
                continue;
            }
            if (capacityRequirement instanceof CpuCapacityRequirement) {
                CpuCapacityRequirement cpuCapacityRequirement = (CpuCapacityRequirement)capacityRequirement;
                cpuCores += cpuCapacityRequirement.getCpu().doubleValue();
                continue;
            }
            throw new IllegalArgumentException("Cannot convert " + capacityRequirement.getClass() + "(" + capacityRequirement + ") into " + this.getClass());
        }
        if (memoryInMB > 0L) {
            this.setMemoryCapacityInMB(memoryInMB);
        }
        if (!megaBytesPerDrive.isEmpty()) {
            this.setDrivesCapacityInMB(megaBytesPerDrive);
        }
        if (cpuCores > 0.0) {
            this.setNumberOfCpuCores(cpuCores);
        }
    }

    @Override
    public void setMemoryCapacityInMB(long memory) {
        this.properties.putLong(MEMORY_CAPACITY_MEGABYTES_KEY, memory);
    }

    @Override
    public long getMemoryCapacityInMB() throws NumberFormatException {
        return this.properties.getLong(MEMORY_CAPACITY_MEGABYTES_KEY, 0L);
    }

    @Override
    public void setNumberOfCpuCores(double cpuCores) {
        this.properties.putDouble(CPU_CAPACITY_CORES_KEY, cpuCores);
    }

    @Override
    public double getNumberOfCpuCores() {
        return this.properties.getDouble(CPU_CAPACITY_CORES_KEY, 0.0);
    }

    public Map<String, String> getProperties() {
        return this.properties.getProperties();
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = new StringProperties(properties);
    }

    public String toString() {
        return this.properties.toString();
    }

    @Override
    public void setDrivesCapacityInMB(Map<String, Long> megaBytesPerDrive) {
        HashMap<String, String> capacityPerDrive = new HashMap<String, String>();
        for (String drive : megaBytesPerDrive.keySet()) {
            capacityPerDrive.put(drive, megaBytesPerDrive.get(drive).toString());
        }
        this.properties.putKeyValuePairs(DRIVE_CAPACITY_MEGABYTES_KEY, capacityPerDrive, DRIVE_CAPACITY_MEGABYTES_PAIR_SEPERATOR, DRIVE_CAPACITY_MEGABYTES_KEYVALUE_SEPERATOR);
    }

    @Override
    public Map<String, Long> getDrivesCapacityInMB() throws NumberFormatException {
        Map capacityPerDrive = this.properties.getKeyValuePairs(DRIVE_CAPACITY_MEGABYTES_KEY, DRIVE_CAPACITY_MEGABYTES_PAIR_SEPERATOR, DRIVE_CAPACITY_MEGABYTES_KEYVALUE_SEPERATOR, DRIVE_CAPACITY_MEGABYTES_DEFAULT);
        HashMap<String, Long> megaBytesPerDrive = new HashMap<String, Long>();
        for (Map.Entry pair : capacityPerDrive.entrySet()) {
            String drive = (String)pair.getKey();
            megaBytesPerDrive.put(drive, Long.valueOf((String)pair.getValue()));
        }
        return megaBytesPerDrive;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CapacityRequirementsConfig other = (CapacityRequirementsConfig)obj;
        return !(this.properties == null ? other.properties != null : !this.properties.equals((Object)other.properties));
    }

    @Override
    public CapacityRequirements toCapacityRequirements() {
        CapacityRequirements capacityRequirements = new CapacityRequirements(new CapacityRequirement[0]).add(new MemoryCapacityRequirement((Long)this.getMemoryCapacityInMB())).add(new CpuCapacityRequirement(this.getNumberOfCpuCores()));
        for (Map.Entry<String, Long> pair : this.getDrivesCapacityInMB().entrySet()) {
            capacityRequirements = capacityRequirements.add(new DriveCapacityRequirement(pair.getKey(), pair.getValue()));
        }
        return capacityRequirements;
    }
}

