/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.pu.elastic.config;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.openspaces.admin.internal.zone.config.ZonesConfigUtils;
import org.openspaces.admin.pu.elastic.config.CapacityRequirementsConfig;
import org.openspaces.admin.pu.elastic.config.ScaleStrategyCapacityRequirementConfig;
import org.openspaces.admin.zone.config.ZonesConfig;
import org.openspaces.core.util.StringProperties;
import org.openspaces.grid.gsm.capacity.CapacityRequirements;
import org.openspaces.grid.gsm.capacity.CapacityRequirementsPerZones;

@Deprecated
public class CapacityRequirementsPerZonesConfig {
    private final StringProperties properties;
    private final String keyPrefix;

    public CapacityRequirementsPerZonesConfig() {
        this("", new CapacityRequirementsPerZones());
    }

    public CapacityRequirementsPerZonesConfig(CapacityRequirementsPerZones capacityRequirementsPerZones) {
        this("", capacityRequirementsPerZones);
    }

    public CapacityRequirementsPerZonesConfig(String keyPrefix, CapacityRequirementsPerZones capacityRequirementsPerZones) {
        this.keyPrefix = keyPrefix;
        this.properties = CapacityRequirementsPerZonesConfig.fromCapacityRequirementsPerZone(keyPrefix, capacityRequirementsPerZones);
    }

    public CapacityRequirementsPerZonesConfig(String keyPrefix, Map<String, String> properties) {
        this.properties = new StringProperties(properties);
        this.keyPrefix = keyPrefix;
    }

    public Map<String, String> getProperties() {
        return this.properties.getProperties();
    }

    public void addCapacity(ZonesConfig zones, ScaleStrategyCapacityRequirementConfig capacity) {
        CapacityRequirements capacityRequirements = capacity.toCapacityRequirements();
        if (!capacityRequirements.equalsZero()) {
            CapacityRequirementsPerZones newCapacityPerZone = this.toCapacityRequirementsPerZones().add(zones, capacityRequirements);
            StringProperties capacityProperties = CapacityRequirementsPerZonesConfig.fromCapacityRequirementsPerZone(this.keyPrefix, newCapacityPerZone);
            this.setCapacityProperties(capacityProperties);
        }
    }

    private void setCapacityProperties(StringProperties capacityProperties) {
        for (String key : new HashSet(this.properties.getProperties().keySet())) {
            if (!key.startsWith(this.keyPrefix)) continue;
            this.properties.remove(key);
        }
        this.properties.putAll(capacityProperties.getProperties());
    }

    public CapacityRequirementsPerZones toCapacityRequirementsPerZones() {
        CapacityRequirementsPerZones capacityPerZone = new CapacityRequirementsPerZones();
        for (Map.Entry<String, Map<String, String>> pair : CapacityRequirementsPerZonesConfig.groupPropertiesByZone(this.keyPrefix, this.properties).entrySet()) {
            CapacityRequirements capacity = new CapacityRequirementsConfig(pair.getValue()).toCapacityRequirements();
            if (capacity.equalsZero()) {
                throw new IllegalStateException("Zone " + pair.getKey() + " cannot have zero capacity:" + capacity + " original properties:" + pair.getValue());
            }
            ZonesConfig zones = ZonesConfigUtils.zonesFromString(pair.getKey());
            capacityPerZone = capacityPerZone.add(zones, capacity);
        }
        return capacityPerZone;
    }

    private static Map<String, Map<String, String>> groupPropertiesByZone(String keyPrefix, StringProperties properties) {
        StringProperties filteredProperties = properties;
        if (keyPrefix.length() > 0) {
            filteredProperties = new StringProperties(properties.getMap(keyPrefix, new HashMap()));
        }
        HashMap<String, Map<String, String>> propertiesByZone = new HashMap<String, Map<String, String>>();
        for (String key : filteredProperties.getProperties().keySet()) {
            int zoneDelimiter;
            String zonesList = key.substring(0, zoneDelimiter = key.indexOf("."));
            if (propertiesByZone.containsKey(zonesList)) continue;
            Map map = filteredProperties.getMap(zonesList + ".", null);
            if (map == null) {
                throw new IllegalStateException("empty map for zones:" + zonesList + " properties=" + properties + " keyPrefix=" + keyPrefix);
            }
            propertiesByZone.put(zonesList, map);
        }
        return propertiesByZone;
    }

    private static StringProperties fromCapacityRequirementsPerZone(String keyPrefix, CapacityRequirementsPerZones capacityPerZone) {
        StringProperties capacityProperties = new StringProperties();
        for (ZonesConfig zones : capacityPerZone.getZones()) {
            CapacityRequirements zonesCapacity = capacityPerZone.getZonesCapacity(zones);
            Map<String, String> properties = new CapacityRequirementsConfig(zonesCapacity).getProperties();
            String key = keyPrefix + ZonesConfigUtils.zonesToString(zones) + ".";
            capacityProperties.putMap(key, properties);
        }
        return capacityProperties;
    }

    public String toString() {
        return this.getPropertiesByZone().toString();
    }

    private Map<String, Map<String, String>> getPropertiesByZone() {
        return CapacityRequirementsPerZonesConfig.groupPropertiesByZone(this.keyPrefix, this.properties);
    }
}

