/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.pu.elastic.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.openspaces.admin.Admin;
import org.openspaces.admin.AdminException;
import org.openspaces.admin.gsa.GridServiceAgent;
import org.openspaces.admin.machine.Machine;
import org.openspaces.admin.pu.elastic.ElasticMachineProvisioningConfig;
import org.openspaces.admin.zone.config.AnyZonesConfig;
import org.openspaces.admin.zone.config.AtLeastOneZoneConfigurer;
import org.openspaces.admin.zone.config.RequiredZonesConfig;
import org.openspaces.core.util.StringProperties;
import org.openspaces.grid.gsm.capacity.CapacityRequirement;
import org.openspaces.grid.gsm.capacity.CapacityRequirements;
import org.openspaces.grid.gsm.capacity.CpuCapacityRequirement;
import org.openspaces.grid.gsm.capacity.DriveCapacityRequirement;
import org.openspaces.grid.gsm.capacity.MemoryCapacityRequirement;
import org.openspaces.grid.gsm.machines.plugins.discovered.DiscoveredMachineProvisioningBean;

@Deprecated
@XmlRootElement(name="discovered-machine-provisioning-config")
public class DiscoveredMachineProvisioningConfig
implements ElasticMachineProvisioningConfig {
    private static final String MINIMUM_NUMBER_OF_CPU_CORES_PER_MACHINE_KEY = "minimum-number-of-cpu-cores-per-machine";
    private static final String MACHINE_AGENT_ZONES_KEY = "machine-agent-zones";
    private static final String[] MACHINE_AGENT_ZONES_DEFAULT = new String[0];
    private static final String RESERVED_MEMORY_CAPACITY_PER_MACHINE_MEGABYTES_KEY = "reserved-memory-capacity-per-machine-megabytes";
    private static final String RESERVED_MEMORY_CAPACITY_PER_MANAGEMENT_MACHINE_MEGABYTES_KEY = "reserved-memory-capacity-per-management-machine-megabytes";
    private static final long RESERVED_MEMORY_CAPACITY_PER_MANAGEMENT_MACHINE_MEGABYTES_DEFAULT = 1024L;
    private static final long RESERVED_MEMORY_CAPACITY_PER_MACHINE_MEGABYTES_DEFAULT = 1024L;
    private static final String DEDICATED_MANAGEMENT_MACHINES_KEY = "dedicated-management-machines";
    private static final boolean DEDICATED_MANAGEMENT_MACHINES_DEFAULT = false;
    private static final boolean MACHINE_AGENT_ZONES_MANDATORY_DEFAULT = false;
    private static final String MACHINE_AGENT_ZONES_MANDATORY_KEY = "machine-agent-zones-is-mandatory";
    private static final String RESREVED_DRIVES_CAPACITY_MEGABYTES_PER_MACHINE_KEY = "resereved-drives-capacity-per-machine-megabytes";
    private static final Map<String, String> RESERVED_DRIVES_CAPACITY_PER_MACHINE_DEFAULT = new HashMap<String, String>();
    private static final String RESREVED_DRIVES_CAPACITY_MEGABYTES_PER_MACHINE_KEY_VALUE_SEPERATOR = "=";
    private static final String RESREVED_DRIVES_CAPACITY_MEGABYTES_PER_MACHINE_PAIR_SEPERATOR = ",";
    private static final String RESERVED_CPU_PER_MACHINE_KEY = "reserved-cpu-cores-per-machine";
    private static final double RESERVED_CPU_PER_MACHINE_DEFAULT = 0.0;
    StringProperties properties = new StringProperties();

    public DiscoveredMachineProvisioningConfig(Map<String, String> properties) {
        this.properties = new StringProperties(properties);
    }

    public DiscoveredMachineProvisioningConfig() {
        this(new HashMap<String, String>());
    }

    @Override
    public String getBeanClassName() {
        return DiscoveredMachineProvisioningBean.class.getName();
    }

    @Override
    public void setProperties(Map<String, String> properties) {
        this.properties.clear();
        this.properties.putAll(properties);
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties.getProperties();
    }

    @Override
    public double getMinimumNumberOfCpuCoresPerMachine() {
        return this.properties.getDouble(MINIMUM_NUMBER_OF_CPU_CORES_PER_MACHINE_KEY, 0.0);
    }

    public void setMinimumNumberOfCpuCoresPerMachine(double minimumNumberOfCpuCoresPerMachine) {
        this.properties.putDouble(MINIMUM_NUMBER_OF_CPU_CORES_PER_MACHINE_KEY, minimumNumberOfCpuCoresPerMachine);
    }

    @Override
    public RequiredZonesConfig getGridServiceAgentZones() {
        String[] zones = this.properties.getArray(MACHINE_AGENT_ZONES_KEY, RESREVED_DRIVES_CAPACITY_MEGABYTES_PER_MACHINE_PAIR_SEPERATOR, MACHINE_AGENT_ZONES_DEFAULT);
        if (zones.length == 0) {
            return new AnyZonesConfig();
        }
        return new AtLeastOneZoneConfigurer().addZones(zones).create();
    }

    @XmlTransient
    public void setGridServiceAgentZones(String[] zones) {
        this.properties.putArray(MACHINE_AGENT_ZONES_KEY, zones, RESREVED_DRIVES_CAPACITY_MEGABYTES_PER_MACHINE_PAIR_SEPERATOR);
    }

    @XmlAttribute(name="grid-service-agents-zones")
    public void setGridServiceAgentsZones(String zones) {
        this.setGridServiceAgentZones(zones.split(RESREVED_DRIVES_CAPACITY_MEGABYTES_PER_MACHINE_PAIR_SEPERATOR));
    }

    @XmlAttribute(name="reserved-memory-capacity-per-machine-in-mb")
    public void setReservedMemoryCapacityPerMachineInMB(long reservedInMB) {
        this.properties.putLong(RESERVED_MEMORY_CAPACITY_PER_MACHINE_MEGABYTES_KEY, reservedInMB);
    }

    @XmlAttribute(name="reserved-memory-capacity-per-management-machine-in-mb")
    public void setReservedMemoryCapacityPerManagementMachineInMB(long reservedInMB) {
        this.properties.putLong(RESERVED_MEMORY_CAPACITY_PER_MANAGEMENT_MACHINE_MEGABYTES_KEY, reservedInMB);
    }

    public Map<String, Long> getReservedDriveCapacityPerMachineInMB() {
        Map reserved = this.properties.getKeyValuePairs(RESREVED_DRIVES_CAPACITY_MEGABYTES_PER_MACHINE_KEY, RESREVED_DRIVES_CAPACITY_MEGABYTES_PER_MACHINE_PAIR_SEPERATOR, RESREVED_DRIVES_CAPACITY_MEGABYTES_PER_MACHINE_KEY_VALUE_SEPERATOR, RESERVED_DRIVES_CAPACITY_PER_MACHINE_DEFAULT);
        HashMap<String, Long> reservedInMB = new HashMap<String, Long>();
        for (Map.Entry pair : reserved.entrySet()) {
            String drive = (String)pair.getKey();
            reservedInMB.put(drive, Long.valueOf((String)pair.getValue()));
        }
        return reservedInMB;
    }

    public void setReservedDriveCapacityPerMachineInMB(Map<String, Long> reservedInMB) {
        HashMap<String, String> reservedInString = new HashMap<String, String>();
        for (Map.Entry<String, Long> pair : reservedInMB.entrySet()) {
            String drive = pair.getKey();
            reservedInString.put(drive, pair.getValue().toString());
        }
        this.properties.putKeyValuePairs(RESREVED_DRIVES_CAPACITY_MEGABYTES_PER_MACHINE_KEY, reservedInString, RESREVED_DRIVES_CAPACITY_MEGABYTES_PER_MACHINE_PAIR_SEPERATOR, RESREVED_DRIVES_CAPACITY_MEGABYTES_PER_MACHINE_KEY_VALUE_SEPERATOR);
    }

    public long getReservedMemoryCapacityPerMachineInMB() {
        return this.properties.getLong(RESERVED_MEMORY_CAPACITY_PER_MACHINE_MEGABYTES_KEY, 1024L);
    }

    public double getReservedCpuCapacityPerMachine() {
        return this.properties.getDouble(RESERVED_CPU_PER_MACHINE_KEY, 0.0);
    }

    public void setReservedCpuCapacityPerMachineInMB(double reservedCpu) {
        this.properties.putDouble(RESERVED_CPU_PER_MACHINE_KEY, reservedCpu);
    }

    @Override
    public CapacityRequirements getReservedCapacityPerMachine() {
        List<CapacityRequirement> requirements = this.createReservedCapacityPerMachine(false);
        return new CapacityRequirements(requirements.toArray(new CapacityRequirement[requirements.size()]));
    }

    @Override
    public CapacityRequirements getReservedCapacityPerManagementMachine() {
        List<CapacityRequirement> requirements = this.createReservedCapacityPerMachine(true);
        return new CapacityRequirements(requirements.toArray(new CapacityRequirement[requirements.size()]));
    }

    public void setReservedCapacityPerMachine(CapacityRequirements capacityRequirements) {
        MemoryCapacityRequirement memoryCapacityRequirement = capacityRequirements.getRequirement(new MemoryCapacityRequirement().getType());
        if (!memoryCapacityRequirement.equalsZero()) {
            this.setReservedMemoryCapacityPerMachineInMB(memoryCapacityRequirement.getMemoryInMB());
        }
        CpuCapacityRequirement cpuCapacityRequirement = capacityRequirements.getRequirement(new CpuCapacityRequirement().getType());
        if (!memoryCapacityRequirement.equalsZero()) {
            this.setReservedCpuCapacityPerMachineInMB(cpuCapacityRequirement.getCpu().doubleValue());
        }
        HashMap<String, Long> reservedInMB = new HashMap<String, Long>();
        for (CapacityRequirement requirement : capacityRequirements.getRequirements()) {
            if (!(requirement instanceof DriveCapacityRequirement)) continue;
            DriveCapacityRequirement driveRequirement = (DriveCapacityRequirement)requirement;
            reservedInMB.put(driveRequirement.getDrive(), driveRequirement.getDriveCapacityInMB());
        }
        this.setReservedDriveCapacityPerMachineInMB(reservedInMB);
    }

    @Override
    public boolean isDedicatedManagementMachines() {
        return this.properties.getBoolean(DEDICATED_MANAGEMENT_MACHINES_KEY, false);
    }

    public void setDedicatedManagementMachines(boolean isDedicatedManagementMachines) {
        this.properties.putBoolean(DEDICATED_MANAGEMENT_MACHINES_KEY, isDedicatedManagementMachines);
    }

    @Override
    @Deprecated
    public boolean isGridServiceAgentZoneMandatory() {
        return this.properties.getBoolean(MACHINE_AGENT_ZONES_MANDATORY_KEY, false);
    }

    @Deprecated
    public void setGridServiceAgentZoneMandatory(boolean zoneMandatory) {
        this.properties.putBoolean(MACHINE_AGENT_ZONES_MANDATORY_KEY, zoneMandatory);
    }

    public static double detectMinimumNumberOfCpuCoresPerMachine(Admin admin) {
        GridServiceAgent[] agents = admin.getGridServiceAgents().getAgents();
        if (agents.length == 0) {
            throw new AdminException("Cannot determine minimum number of cpu cores per machine. Please use new AdvancedElasticStatefulProcessingUnit().minNumberOfCpuCoresPerMachine() to specify this figure.");
        }
        double minCoresPerMachine = DiscoveredMachineProvisioningConfig.getNumberOfCpuCores(agents[0].getMachine());
        for (GridServiceAgent agent : agents) {
            double cores = DiscoveredMachineProvisioningConfig.getNumberOfCpuCores(agent.getMachine());
            if (cores <= 0.0) {
                throw new AdminException("Cannot determine number of cpu cores on machine " + agent.getMachine().getHostAddress());
            }
            if (!(minCoresPerMachine < cores)) continue;
            minCoresPerMachine = cores;
        }
        return minCoresPerMachine;
    }

    private static double getNumberOfCpuCores(Machine machine) {
        return machine.getOperatingSystem().getDetails().getAvailableProcessors();
    }

    private List<CapacityRequirement> createReservedCapacityPerMachine(boolean management) {
        ArrayList<CapacityRequirement> requirements = new ArrayList<CapacityRequirement>();
        if (management) {
            requirements.add(new MemoryCapacityRequirement(this.getReservedMemoryCapacityPerManagementMachineInMB()));
        } else {
            requirements.add(new MemoryCapacityRequirement((Long)this.getReservedMemoryCapacityPerMachineInMB()));
        }
        requirements.add(new CpuCapacityRequirement(this.getReservedCpuCapacityPerMachine()));
        Map<String, Long> reservedDriveCapacity = this.getReservedDriveCapacityPerMachineInMB();
        for (Map.Entry<String, Long> entry : reservedDriveCapacity.entrySet()) {
            String drive = entry.getKey();
            requirements.add(new DriveCapacityRequirement(drive, entry.getValue()));
        }
        return requirements;
    }

    public Long getReservedMemoryCapacityPerManagementMachineInMB() {
        return this.properties.getLong(RESERVED_MEMORY_CAPACITY_PER_MANAGEMENT_MACHINE_MEGABYTES_KEY, 1024L);
    }
}

