/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.pu.elastic.config;

import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.openspaces.admin.Admin;
import org.openspaces.admin.internal.pu.elastic.GridServiceContainerConfig;
import org.openspaces.admin.internal.pu.elastic.ProcessingUnitSchemaConfig;
import org.openspaces.admin.internal.pu.elastic.config.AbstractElasticProcessingUnitConfig;
import org.openspaces.admin.pu.config.ProcessingUnitConfig;
import org.openspaces.admin.pu.config.UserDetailsConfig;
import org.openspaces.admin.pu.dependency.ProcessingUnitDependency;
import org.openspaces.admin.pu.elastic.ElasticMachineProvisioningConfig;
import org.openspaces.admin.pu.elastic.config.DiscoveredMachineProvisioningConfig;
import org.openspaces.admin.pu.elastic.config.ScaleStrategyConfig;
import org.openspaces.admin.pu.elastic.topology.DedicatedMachineProvisioningInternal;
import org.openspaces.admin.pu.elastic.topology.SharedMachineProvisioningInternal;
import org.openspaces.admin.pu.topology.ElasticStatefulProcessingUnitConfigHolder;

@Deprecated
@XmlRootElement(name="elastic-stateful-pu")
public class ElasticStatefulProcessingUnitConfig
extends AbstractElasticProcessingUnitConfig
implements ElasticStatefulProcessingUnitConfigHolder {
    public static final String MAX_MEMORY_CAPACITY_MEGABYTES_DYNAMIC_PROPERTY = "max-memory-capacity-megabytes";
    public static final String MIN_MEMORY_CAPACITY_MEGABYTES_DYNAMIC_PROPERTY = "min-memory-capacity-megabytes";
    Map<String, String> scaleStrategy;
    private long maxMemoryCapacityInMB;
    private int numberOfBackupInstancesPerPartition = 1;
    private int numberOfPartitions;
    private int maxProcessingUnitInstancesFromSamePartitionPerMachine = 1;
    private double maxNumberOfCpuCores;
    private double minNumberOfCpuCoresPerMachine;
    private Admin admin;
    private boolean allowAboveAverageMemoryPerMachine;

    public ElasticStatefulProcessingUnitConfig() {
        new ProcessingUnitSchemaConfig(super.getElasticProperties()).setPartitionedSchema();
    }

    @Override
    public ProcessingUnitConfig toProcessingUnitConfig() {
        ProcessingUnitConfig config = super.toProcessingUnitConfig();
        if (this.getMachineProvisioning() != null && this.getMinNumberOfCpuCoresPerMachine() <= 0.0) {
            this.setMinNumberOfCpuCoresPerMachine(super.getMachineProvisioning().getMinimumNumberOfCpuCoresPerMachine());
            if (this.getMinNumberOfCpuCoresPerMachine() <= 0.0 && !(this.getMachineProvisioning() instanceof DiscoveredMachineProvisioningConfig)) {
                throw new IllegalStateException("Elastic Machine Provisioning configuration must supply the expected minimum number of CPU cores per machine.");
            }
        }
        if (this.getMaxMemoryCapacityInMB() == 0L && this.getNumberOfPartitions() == 0) {
            throw new IllegalStateException("maxMemoryCapacity must be defined.");
        }
        if (this.getMaxMemoryCapacityInMB() != 0L && this.getNumberOfPartitions() != 0) {
            throw new IllegalStateException("numberOfPartitions conflicts with maxMemoryCapacity. Please specify only one of these properties.");
        }
        if (this.getMaxNumberOfCpuCores() != 0.0 && this.getNumberOfPartitions() != 0) {
            throw new IllegalStateException("numberOfPartitions conflicts with maxNumberOfCpuCores. Please specify only one of these properties.");
        }
        int numberOfInstances = this.getNumberOfPartitions();
        if (numberOfInstances == 0) {
            numberOfInstances = Math.max(this.calcNumberOfPartitionsFromMemoryRequirements(), this.calcNumberOfPartitionsFromCpuRequirements(this.admin));
        }
        if (this.getNumberOfBackupInstancesPerPartition() == 0) {
            config.setMaxInstancesPerMachine(0);
            config.setMaxInstancesPerVM(0);
        } else {
            config.setMaxInstancesPerVM(1);
            config.setMaxInstancesPerMachine(this.getMaxProcessingUnitInstancesFromSamePartitionPerMachine());
        }
        config.setClusterSchema("partitioned");
        config.setNumberOfInstances(numberOfInstances);
        config.setNumberOfBackups(this.getNumberOfBackupInstancesPerPartition());
        return config;
    }

    protected int calcNumberOfPartitionsFromMemoryRequirements() {
        long maximumMemoryCapacityInMB = new GridServiceContainerConfig(super.getElasticProperties()).getMaximumMemoryCapacityInMB();
        if (maximumMemoryCapacityInMB <= 0L) {
            throw new IllegalStateException("memoryCapacityPerContainer is undefined.");
        }
        double totalNumberOfInstances = Math.ceil((double)this.getMaxMemoryCapacityInMB() / (double)maximumMemoryCapacityInMB);
        int numberOfPartitions = (int)Math.ceil(totalNumberOfInstances / (double)(this.getNumberOfBackupInstancesPerPartition() + 1));
        return Math.max(1, numberOfPartitions);
    }

    protected int calcNumberOfPartitionsFromCpuRequirements(Admin admin) {
        int maximumNumberOfPrimaryInstances = 1;
        if (this.getMaxNumberOfCpuCores() > 0.0) {
            if (this.getMinNumberOfCpuCoresPerMachine() <= 0.0) {
                if (admin == null) {
                    throw new IllegalStateException("call #setAdmin() or #setNumberOfPartitions() before calling toProcessingUnitConfig()");
                }
                this.setMinNumberOfCpuCoresPerMachine(DiscoveredMachineProvisioningConfig.detectMinimumNumberOfCpuCoresPerMachine(admin));
            }
            maximumNumberOfPrimaryInstances = (int)Math.ceil(this.getMaxNumberOfCpuCores() / this.getMinNumberOfCpuCoresPerMachine());
        }
        return maximumNumberOfPrimaryInstances;
    }

    public long getMaxMemoryCapacityInMB() {
        return this.maxMemoryCapacityInMB;
    }

    public int getNumberOfBackupInstancesPerPartition() {
        return this.numberOfBackupInstancesPerPartition;
    }

    @XmlAttribute(name="number-of-backups-per-partition")
    public void setNumberOfBackupInstancesPerPartition(int numberOfBackupInstancesPerPartition) {
        this.numberOfBackupInstancesPerPartition = numberOfBackupInstancesPerPartition;
    }

    public int getNumberOfPartitions() {
        return this.numberOfPartitions;
    }

    public int getMaxProcessingUnitInstancesFromSamePartitionPerMachine() {
        return this.maxProcessingUnitInstancesFromSamePartitionPerMachine;
    }

    public void setMaxProcessingUnitInstancesFromSamePartitionPerMachine(int maxProcessingUnitInstancesFromSamePartitionPerMachine) {
        this.maxProcessingUnitInstancesFromSamePartitionPerMachine = maxProcessingUnitInstancesFromSamePartitionPerMachine;
    }

    public double getMaxNumberOfCpuCores() {
        return this.maxNumberOfCpuCores;
    }

    @Deprecated
    public double getMinNumberOfCpuCoresPerMachine() {
        return this.minNumberOfCpuCoresPerMachine;
    }

    @Deprecated
    public void setMinNumberOfCpuCoresPerMachine(double minNumberOfCpuCoresPerMachine) {
        this.minNumberOfCpuCoresPerMachine = minNumberOfCpuCoresPerMachine;
    }

    public boolean isAllowAboveAverageMemoryPerMachine() {
        return this.allowAboveAverageMemoryPerMachine;
    }

    public void setAllowAboveAverageMemoryPerMachine(boolean allowAboveAverageMemoryPerMachine) {
        this.allowAboveAverageMemoryPerMachine = allowAboveAverageMemoryPerMachine;
    }

    @Override
    public void setAdmin(Admin admin) {
        this.admin = admin;
    }

    @XmlAttribute(name="max-number-of-cpu-cores")
    public void setMaxNumberOfCpuCores(double maxNumberOfCpuCores) {
        this.maxNumberOfCpuCores = maxNumberOfCpuCores;
    }

    @XmlAttribute(name="number-of-partitions")
    public void setNumberOfPartitions(int numberOfPartitions) {
        this.numberOfPartitions = numberOfPartitions;
    }

    @XmlAttribute(name="file")
    public void setProcessingUnitFile(String processingUnitFilePath) {
        super.setProcessingUnit(processingUnitFilePath);
    }

    @XmlAttribute(name="puname")
    public void setProcessingUnitName(String processingUnitName) {
        super.setProcessingUnit(processingUnitName);
    }

    @XmlAttribute(name="max-memory-capacity-in-mb")
    public void setMaxMemoryCapacityInMB(long maxMemoryCapacityInMB) {
        this.maxMemoryCapacityInMB = maxMemoryCapacityInMB;
    }

    @Override
    @XmlElement(type=UserDetailsConfig.class)
    public void setUserDetails(UserDetailsConfig userDetails) {
        super.setUserDetails(userDetails);
    }

    @Override
    @XmlAttribute(name="secured")
    public void setSecured(Boolean secured) {
        super.setSecured(secured);
    }

    @Override
    @XmlAttribute(name="memory-capacity-per-container-in-mb")
    public void setMemoryCapacityPerContainerInMB(long memoryInMB) {
        super.setMemoryCapacityPerContainerInMB(memoryInMB);
    }

    @Override
    @XmlElement(type=ElasticMachineProvisioningConfig.class)
    public void setMachineProvisioning(ElasticMachineProvisioningConfig machineProvisioningConfig) {
        super.setMachineProvisioning(machineProvisioningConfig);
    }

    @Override
    @XmlElement(type=ScaleStrategyConfig.class)
    public void setScaleStrategy(ScaleStrategyConfig scaleStrategy) {
        super.setScaleStrategy(scaleStrategy);
    }

    @XmlAttribute(name="highly-available")
    public void setHighlyAvailable(boolean highlyAvailable) {
        this.setNumberOfBackupInstancesPerPartition(highlyAvailable ? 1 : 0);
    }

    @XmlAttribute(name="single-machine-deployment")
    public void setSingleMachineDeployment(boolean singleMachineDeployment) {
        if (singleMachineDeployment) {
            this.setMaxProcessingUnitInstancesFromSamePartitionPerMachine(0);
        }
    }

    @Override
    @XmlElement(type=ProcessingUnitDependency.class)
    public void setDeploymentDependencies(ProcessingUnitDependency[] dependencies) {
        super.setDeploymentDependencies(dependencies);
    }

    @XmlElement(type=SharedMachineProvisioningInternal.class)
    public void setSharedMachineProvisioning(SharedMachineProvisioningInternal sharedMachineProvisioningInternal) {
        this.setSharedIsolation(sharedMachineProvisioningInternal.getSharingId());
        this.setMachineProvisioning(sharedMachineProvisioningInternal.getElasticMachineProvisioningConfig());
    }

    @XmlElement(type=DedicatedMachineProvisioningInternal.class)
    public void setDedicatedMachineProvisioning(DedicatedMachineProvisioningInternal dedicatedMachineProvisioningInternal) {
        this.setDedicatedIsolation();
        this.setMachineProvisioning(dedicatedMachineProvisioningInternal.getElasticMachineProvisioningConfig());
    }
}

