/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.admin.pu.elastic.events;

import com.gigaspaces.internal.io.IOUtils;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import org.openspaces.admin.internal.pu.elastic.events.AbstractElasticProcessingUnitDecisionEvent;
import org.openspaces.admin.pu.elastic.config.AutomaticCapacityScaleRuleConfig;
import org.openspaces.admin.pu.elastic.events.ElasticAutoScalingProgressChangedEvent;

@Deprecated
public class ElasticStatelessProcessingUnitPlannedNumberOfInstancesChangedEvent
extends AbstractElasticProcessingUnitDecisionEvent
implements ElasticAutoScalingProgressChangedEvent {
    private static final long serialVersionUID = 1L;
    private int oldPlannedNumberOfInstances;
    private int newPlannedNumberOfInstances;
    private int actualNumberOfInstances;
    private AutomaticCapacityScaleRuleConfig rule;
    private boolean highThresholdBreached;
    private String metricValue;

    public ElasticStatelessProcessingUnitPlannedNumberOfInstancesChangedEvent() {
    }

    public ElasticStatelessProcessingUnitPlannedNumberOfInstancesChangedEvent(int actualNumberOfInstances, int oldPlannedNumberOfInstances, int newPlannedNumberOfInstances) {
        this(actualNumberOfInstances, oldPlannedNumberOfInstances, newPlannedNumberOfInstances, null, false, null);
    }

    public ElasticStatelessProcessingUnitPlannedNumberOfInstancesChangedEvent(int actualNumberOfInstances, int oldPlannedNumberOfInstances, int newPlannedNumberOfInstances, AutomaticCapacityScaleRuleConfig rule, boolean highThresholdBreached, String metricValue) {
        this.actualNumberOfInstances = actualNumberOfInstances;
        this.oldPlannedNumberOfInstances = oldPlannedNumberOfInstances;
        this.newPlannedNumberOfInstances = newPlannedNumberOfInstances;
        this.rule = rule;
        this.highThresholdBreached = highThresholdBreached;
        this.metricValue = metricValue;
    }

    public int getNewPlannedNumberOfInstances() {
        return this.newPlannedNumberOfInstances;
    }

    public int getBeforePlannedNumberOfInstances() {
        return this.oldPlannedNumberOfInstances;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.oldPlannedNumberOfInstances);
        out.writeInt(this.newPlannedNumberOfInstances);
        out.writeInt(this.actualNumberOfInstances);
        out.writeBoolean(this.highThresholdBreached);
        IOUtils.writeString((ObjectOutput)out, (String)this.metricValue);
        this.writeRule(out, this.rule);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.oldPlannedNumberOfInstances = in.readInt();
        this.newPlannedNumberOfInstances = in.readInt();
        this.actualNumberOfInstances = in.readInt();
        this.highThresholdBreached = in.readBoolean();
        this.metricValue = IOUtils.readString((ObjectInput)in);
        this.rule = ElasticStatelessProcessingUnitPlannedNumberOfInstancesChangedEvent.readRule(in);
    }

    private void writeRule(ObjectOutput out, AutomaticCapacityScaleRuleConfig rule) throws IOException {
        Map properties = null;
        if (rule != null) {
            rule.getProperties();
        }
        IOUtils.writeMapStringString((ObjectOutput)out, properties);
    }

    private static AutomaticCapacityScaleRuleConfig readRule(ObjectInput in) throws IOException, ClassNotFoundException {
        AutomaticCapacityScaleRuleConfig rule = null;
        Map properties = IOUtils.readMapStringString((ObjectInput)in);
        if (properties != null) {
            rule = new AutomaticCapacityScaleRuleConfig(properties);
        }
        return rule;
    }

    @Override
    public String getDecisionDescription() {
        StringBuilder desc = new StringBuilder();
        if (this.newPlannedNumberOfInstances > this.actualNumberOfInstances) {
            desc.append("Scaling out. ");
        } else if (this.newPlannedNumberOfInstances < this.actualNumberOfInstances) {
            desc.append("Scaling in. ");
        }
        if (this.rule != null) {
            desc.append(this.rule.getStatistics().getMetric()).append(" (").append(this.metricValue).append(") is ");
            if (this.highThresholdBreached) {
                desc.append("above high threshold (" + this.rule.getHighThreshold() + "). ");
            } else {
                desc.append("below low threshold (" + this.rule.getLowThreshold() + "). ");
            }
        }
        if (this.oldPlannedNumberOfInstances != this.newPlannedNumberOfInstances) {
            desc.append("Number of planned instances changed from ").append(this.oldPlannedNumberOfInstances).append(" to ").append(this.newPlannedNumberOfInstances).append(". ");
        } else {
            desc.append("Number of planned instances is ").append(this.newPlannedNumberOfInstances).append(". ");
        }
        desc.append("Actual number of instances is ").append(this.actualNumberOfInstances).append(". ");
        return desc.toString();
    }

    public AutomaticCapacityScaleRuleConfig getRule() {
        return this.rule;
    }

    public boolean isHighThresholdBreached() {
        return this.rule != null && this.highThresholdBreached;
    }

    public boolean isLowThresholdBreached() {
        return this.rule != null && !this.highThresholdBreached;
    }

    public String getMetricValue() {
        return this.metricValue;
    }
}

